% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/debian.R
\name{debian}
\alias{debian}
\alias{debian_add_swap}
\alias{debian_install_r}
\alias{debian_install_rstudio}
\alias{debian_install_shiny}
\alias{debian_apt_get_update}
\alias{debian_apt_get_install}
\alias{install_r_package}
\alias{install_github_r_package}
\title{Helpers for managing a debian droplets.}
\usage{
debian_add_swap(
  droplet,
  user = "root",
  keyfile = NULL,
  ssh_passwd = NULL,
  verbose = FALSE
)

debian_install_r(
  droplet,
  user = "root",
  keyfile = NULL,
  ssh_passwd = NULL,
  verbose = FALSE,
  rprofile = "options(repos=c('CRAN'='https://cloud.r-project.org/'))"
)

debian_install_rstudio(
  droplet,
  user = "rstudio",
  password = "server",
  version = "0.99.484",
  keyfile = NULL,
  ssh_passwd = NULL,
  verbose = FALSE
)

debian_install_shiny(
  droplet,
  version = "1.4.0.756",
  user = "root",
  keyfile = NULL,
  ssh_passwd = NULL,
  verbose = FALSE,
  rprofile = "options(repos=c('CRAN'='https://cloud.r-project.org/'))"
)

debian_apt_get_update(
  droplet,
  user = "root",
  keyfile = NULL,
  ssh_passwd = NULL,
  verbose = FALSE
)

debian_apt_get_install(
  droplet,
  ...,
  user = "root",
  keyfile = NULL,
  ssh_passwd = NULL,
  verbose = FALSE
)

install_r_package(
  droplet,
  package,
  repo = "https://cloud.r-project.org/",
  user = "root",
  keyfile = NULL,
  ssh_passwd = NULL,
  verbose = FALSE
)

install_github_r_package(
  droplet,
  package,
  repo = "https://cloud.r-project.org/",
  user = "root",
  keyfile = NULL,
  ssh_passwd = NULL,
  verbose = FALSE
)
}
\arguments{
\item{droplet}{A droplet, or object that can be coerced to a droplet
by \code{\link{as.droplet}}.}

\item{user}{Default username for Rstudio.}

\item{keyfile}{Optional private key file.}

\item{ssh_passwd}{Optional passphrase or callback function for authentication.
Refer to the \code{ssh::ssh_connect} documentation for more
details.}

\item{verbose}{If TRUE, will print command before executing it.}

\item{rprofile}{A character string that will be added to the .Rprofile}

\item{password}{Default password for Rstudio.}

\item{version}{Version of rstudio to install.}

\item{...}{Arguments to apt-get install.}

\item{package}{Name of R package to install.}

\item{repo}{CRAN mirror to use.}
}
\description{
Helpers for managing a debian droplets.
}
\examples{
\dontrun{
d <- droplet_create()
d \%>\% debian_add_swap()
d \%>\% debian_apt_get_update()

d \%>\% debian_install_r()
d \%>\% debian_install_rstudio()

# Install libcurl, then build RCurl from source
d \%>\% debian_apt_get_install("libcurl4-openssl-dev")
d \%>\% install_r_package("RCurl")
droplet_delete(d)
}
}
