% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\docType{methods}
\name{plotMAD}
\alias{plotMAD}
\alias{plotMAD,MADproject,ANY-method}
\alias{plotMAD,MADproject,character-method}
\title{Plot the data contained in MADproject object slots.}
\usage{
plotMAD(x, y)

\S4method{plotMAD}{MADproject,ANY}(x)

\S4method{plotMAD}{MADproject,character}(x, y)
}
\arguments{
\item{x}{The MADproject object}

\item{y}{character string from the following options: "observations",
"realizations", "priors", or "posteriors"}
}
\description{
\code{plot} plots the data contained in various
slots of the provided MADproject. If no specific slot is
specified, all slots that can be plotted will be.
}
\details{
All plots utilize \pkg{ggplot2} plotting functions. The slots
that can be plotted are \code{priors}, \code{observations},
\code{realizations}, and \code{posteriors}.
}
\section{Methods (by class)}{
\itemize{
\item \code{x = MADproject,y = ANY}: Plots all available slots in the MADproject object

\item \code{x = MADproject,y = character}: Plots the \code{y} slot in the MADproject object
}}

\examples{
data(pumping)
plotMAD(pumping, "realizations")
plotMAD(pumping, "priors")
plotMAD(pumping, "posteriors")
plotMAD(pumping)


}
