% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/and.R
\name{and}
\alias{and}
\alias{or}
\title{Combine a vector into a natural language string}
\source{
Language data is derived from the
\href{https://cldr.unicode.org/}{Unicode Common Locale Data Repository (CLDR)}
}
\usage{
and(x, ..., language = NULL)

or(x, ..., language = NULL)
}
\arguments{
\item{x}{A list of \link{character} strings to combine}

\item{...}{These dots are for future extensions and must be empty.}

\item{language}{The language to use for translation.
If \code{\link{NULL}}, the default, the language of the user's R session is used.

Codes should should be two or three lowercase letters representing the
language, optionally followed by an underscore and two uppercase letters
representing a territory.
For example, \code{"es"} represents Spanish and
\code{"en_US"} represents American English.

If a territory is specified but there is no specific translation for that
territory, translations fall back to the general language.
For example, \code{and} does not include specific translations for
Canadian French, so \code{"fr_CA"} falls back to \code{"fr"}.

If a language is specified that is not supported by \code{and}, translations
fall back to English.
For a list of supported languages, see \link{and_languages}.}
}
\value{
A \link{character} string of length 1
}
\description{
These functions transform a vector into a single string similar to
\code{\link[knitr:combine_words]{knitr::combine_words()}} or \code{\link[glue:glue_collapse]{glue::glue_collapse()}}.

\code{and()} and \code{or()} natively support localization, using translations and
punctuation to match the users' language settings.
See \link{and_languages} for available languages.
\itemize{
\item \code{and()} combines words using the native conjunctive ("and" in English)
\item \code{or()} combines words using the native disjunctive ("or" in English)
}
}
\examples{
and(1:3)
or(1:3)

and(1:3, language = "es")
or(1:3, language = "ja")

}
