% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation_analysis.R
\name{correlation_analyze}
\alias{correlation_analyze}
\title{To perform correlation analysis for local network metrics}
\usage{
correlation_analyze(
  network,
  n_simulations = 10,
  subsampling_proportion = c(0.1, 0.3, 0.5, 0.7, 0.9),
  network_metrics = c("degree", "strength", "betweenness", "clustering_coefficient",
    "eigenvector_centrality")
)
}
\arguments{
\item{network}{An igraph graph object consisting of observed network}

\item{n_simulations}{Number of sub-samples to be obtained at each level}

\item{subsampling_proportion}{A vector depicting proportions of sub-sampled nodes}

\item{network_metrics}{A vector depicting names of local global network metrics}
}
\value{
A list of network metrics of class list_correlation_matrices. Each element of list is a matrix whose columns 
        correspond to subsampling_proportion and rows correspond to n_simulations.
        The entries of the matrix provide value of correlation between the nodes in 
        full network and the sub-sampled network for the corresponding metric.
}
\description{
To perform correlation analysis for local network metrics
}
\examples{
\donttest{
data(elk_network_2010)
correlation_analyze(elk_network_2010)
}
}
