% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postprocessing.R
\name{anim.save}
\alias{anim.save}
\title{Save an anim.frames object in various formats.}
\usage{
anim.save(
  obj,
  filename,
  type = switch(file_ext(filename), gif = "GIF", mp4 = "Video", swf = "SWF", html =
    "HTML", tex = "Latex"),
  ...
)
}
\arguments{
\item{obj}{an \code{anim.frames} object, or an expression to evaluate}

\item{filename}{file to save to}

\item{type}{one of 'GIF', 'Video', 'SWF', 'HTML', or 'Latex'}

\item{...}{arguments passed to e.g. \code{\link{saveGIF}}}
}
\description{
This function simply calls replay on the object and then calls
\code{\link{saveGIF}} and friends on the result.
}
\examples{

\dontrun{
tmp <- anim.plot(1:10, 1:10, pch=1:10, show=FALSE)
anim.save(tmp, "mygif.gif")

anim.save(replay(tmp, after=legend("topleft", legend="My legend")), 
   "mygif2.gif")
}

}
