% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.r
\name{labs}
\alias{labs}
\alias{xlab}
\alias{ylab}
\alias{ggtitle}
\title{Change axis labels, legend titles, plot title/subtitle and below-plot
caption.}
\usage{
labs(...)

xlab(label)

ylab(label)

ggtitle(label, subtitle = NULL)
}
\arguments{
\item{...}{a list of new names in the form aesthetic = "new name"}

\item{label}{The text for the axis, plot title or caption below the plot.}

\item{subtitle}{the text for the subtitle for the plot which will be
displayed below the title. Leave \code{NULL} for no subtitle.}
}
\description{
Change axis labels, legend titles, plot title/subtitle and below-plot
caption.
}
\examples{
p <- ggplot(mtcars, aes(mpg, wt)) + geom_point()
p + labs(title = "New plot title")
p + labs(x = "New x label")
p + xlab("New x label")
p + ylab("New y label")
p + ggtitle("New plot title")

# Can add a subtitle to plots with either of the following
p + ggtitle("New plot title", subtitle = "A subtitle")
p + labs(title = "New plot title", subtitle = "A subtitle")

# Can add a plot caption underneath the whole plot (for sources, notes or
# copyright), similar to the \\code{sub} parameter in base R, with the
# following
p + labs(caption = "(based on data from ...)")

# This should work independently of other functions that modify the
# the scale names
p + ylab("New y label") + ylim(2, 4)
p + ylim(2, 4) + ylab("New y label")

# The labs function also modifies legend labels
p <- ggplot(mtcars, aes(mpg, wt, colour = cyl)) + geom_point()
p + labs(colour = "Cylinders")

# Can also pass in a list, if that is more convenient
p + labs(list(title = "Title", subtitle = "Subtitle", x = "X", y = "Y"))
}
