% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classifyMD.R
\name{classifyImagesBatchMD}
\alias{classifyImagesBatchMD}
\title{Run MegaDetector on a batch of images}
\usage{
classifyImagesBatchMD(
  mdsession,
  images,
  min_conf = 0.1,
  batch_size = 1,
  resultsfile = NULL,
  checkpoint = 5000
)
}
\arguments{
\item{mdsession}{should be the output from loadMDmodel(model)}

\item{images}{list of image filepaths}

\item{min_conf}{Confidence threshold for returning bounding boxes, defaults to 0.1}

\item{batch_size}{Process images in batches, defaults to 1}

\item{resultsfile}{File containing previously checkpointed results}

\item{checkpoint}{Bank results after processing a number of images, defaults to 5000}
}
\value{
a list of lists of bounding boxes for each image
}
\description{
Runs MD on a list of image filepaths.
Can resume for a results file and will checkpoint the results after a set
number of images
}
\examples{
\dontrun{
 images<-read_exif(imagedir,tags=c("filename","directory","DateTimeOriginal","FileModifyDate"),
 recursive = TRUE)
 colnames(images)[1]<-"FilePath"
 mdsession<-loadMDModel(mdmodel)
 mdres<-classifyImagesBatchMD(mdsession,images$FilePath,
                              resultsfile=mdresultsfile,checkpoint = 2500)
}
}
