% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.r
\name{print}
\alias{print}
\alias{print.annmatrix}
\title{Print annmatrix Object}
\usage{
\method{print}{annmatrix}(x, nrow = 5, ncol = 5, digits = getOption("digits"), ...)
}
\arguments{
\item{x}{a matrix.}

\item{nrow}{number of rows to display (default is 5).}

\item{ncol}{number of columns to display (default is 5).}

\item{digits}{number of digits to display (default set to getOptions("digits")).}

\item{...}{further arguments passed to or from methods.}
}
\value{
invisibly returns annmatrix object.
}
\description{
Functions that print an annmatrix object
}
\details{
annmatrix objects are printed in a shortened form (5 rows and 5 columns by default).
In addition the function displays information about available meta-data for rows and columns.
}
\examples{
# construct annmatrix object
x <- matrix(rnorm(20*10), 20, 10)

coldata <- data.frame(group  = rep(c("case", "control"), each = 5),
                      gender = sample(c("M", "F"), 10, replace = TRUE))

rowdata <- data.frame(chr = sample(c("chr1", "chr2"), 20, replace = TRUE),
                      pos = runif(20, 0, 1000000))

X <- annmatrix(x, rowdata, coldata)

print(X)
print(X, 10, 5)
print(X, 2, 2)

# also works with a list-based matrix
x <- matrix(list(mtcars, iris3, USAccDeaths, rivers), ncol=2)
print(x)
X <- annmatrix(x)
print(X)

}
\author{
Karolis Koncevičius
}
