% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{del}
\alias{del}
\title{Delete table or database (text file, sqlite, mysql)}
\usage{
del(filename = "", sqlite.connect.params = list(),
  mysql.connect.params = list(), del.type = "database",
  db.type = "sqlite", verbose = FALSE, ...)
}
\arguments{
\item{filename}{Path of text format data}

\item{sqlite.connect.params}{Connect to sqlite database params [dbname, table.name]}

\item{mysql.connect.params}{Mysql parameters, [host, dbname, table.name, user, password etc.]}

\item{del.type}{file (for filename), database (for sqlite and MySQL), table (for sqlite and MySQL) 
be supported (delete file, delete sqlite db file, delete table in sqlite db,
delete table in MySQL db and delete database in MySQL database)}

\item{db.type}{txt, sqlite or mysql}

\item{verbose}{Ligical indicating wheather show the log message}

\item{...}{Other parameters be used in dbSendQuery}
}
\description{
Delete table or database (text file, sqlite, mysql)
}
\examples{
db <- tempfile()
file.create(db)
del(db, del.type = 'file')
test.dat <- system.file('extdata', 'demo/sqlite.dat.txt', package = 'annovarR')
test.sqlite <- sprintf('\%s/snp.test.sqlite', tempdir())
x <- sqlite.build(filename = test.dat, list(dbname = test.sqlite, 
table.name = 'snp_test'))
del(sqlite.connect.params = list(dbname = test.sqlite, 
table.name = 'snp_test'), del.type = 'table')
del(sqlite.connect.params = list(dbname = test.sqlite, 
table.name = 'snp_test'))
}
