% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto.R
\name{sqlite.auto.index}
\alias{sqlite.auto.index}
\title{Index annovarR database in sqlite (auto from extdata/config/database.toml)}
\usage{
sqlite.auto.index(anno.name = "", buildver = "hg19",
  database.dir = "/path/", index = "chr_start_index", db.type = "sqlite",
  database.cfg = system.file("extdata", "config/databases.toml", package =
  "annovarR"), verbose = TRUE)
}
\arguments{
\item{anno.name}{Annotation name, eg. avsnp138, avsnp147, 1000g2015aug_all}

\item{buildver}{Genome version, hg19, hg38, mm10 and others}

\item{database.dir}{Dir of the databases}

\item{index}{Index name in sqlite}

\item{db.type}{Setting the database type (sqlite, txt or mysql)}

\item{database.cfg}{Configuration file of annovarR databases infomation}

\item{verbose}{Logical indicating wheather print the extra log infomation}
}
\description{
Index annovarR database in sqlite (auto from extdata/config/database.toml)
}
\examples{
i <- 'hg19_avsnp147'
database <- system.file('extdata', sprintf('demo/\%s.txt', i), package = 'annovarR')
file.copy(database, sprintf('\%s/\%s.txt', tempdir(), i))
sqlite.auto.build('avsnp147', 'hg19', database.dir = tempdir(), verbose = TRUE)
sqlite.auto.index('avsnp147', 'hg19', database.dir = tempdir(), index = 'chr_start_index2',
verbose = TRUE)
unlink(sprintf('\%s/\%s.txt', tempdir(), i))
unlink(sprintf('\%s/\%s.sqlite', tempdir(), i))
}
