database.dir <- tempdir()
for (i in c("hg19_avsnp147", "hg19_cosmic81", "hg19_ALL.sites.2015_08", 
  "hg19_RADAR2", "hg19_DARNED", "hg19_normal2016sih_wes_ball", "hg19_normal2016sih_wes_nkt", 
  "hg19_normal2016sih_wes_tall", "hg19_normal2016sih_wgs_nkt", "hg19_normal2016sih_wgs_dlbcl", 
  "hg19_clinvar_20170130", "hg19_intervar_20170202", "hg19_REDIportal", "hg19_caddgt10", 
  "hg19_nci60", "hg19_icgc21", "hg19_dbnsfp30a", "hg19_dbnsfp33a", "hg19_dbnsfp31a_interpro", 
  "hg19_gme", "hg19_hrcr1", "hg19_revel", "hg19_mcap", "hg19_exac03", "hg19_exac03nontcga", 
  "hg19_exac03nonpsych", "hg19_gnomad_exome", "hg19_gnomad_genome", "hg19_gwava", 
  "hg19_kaviar_20150923", "hg19_popfreq_all_20150413", "hg19_popfreq_max_20150413", 
  "hg19_eigen", "hg19_caddgt20")) {
  database <- system.file("extdata", sprintf("demo/sqlite/%s.sqlite", i), package = "annovarR")
  file.copy(database, sprintf("%s/%s.sqlite", tempdir(), i))
  database <- system.file("extdata", sprintf("demo/%s.txt", i), package = "annovarR")
  file.copy(database, sprintf("%s/%s.txt", tempdir(), i))
  #database <- system.file("extdata", sprintf("demo/%s.txt", i), package = "annovarR")
  #sqlite.db <- sprintf("%s/%s.sqlite", tempdir(), i)
  #file.copy(database, sprintf("%s/%s.txt", tempdir(), i))
  #sqlite.build(database, sqlite.connect.params = list(dbname = sqlite.db, table.name = sprintf("%s", 
  #  i)))
}

test_that("annotation.cols.match", {
  chr <- c("chr1", "chr2", "chr1")
  start <- c("10020", "10020", "10020")
  end <- c("10020", "10020", "10020")
  ref <- c("A", "A", "A")
  alt <- c("-", "-", "-")
  dat <- data.table(chr = chr, start = start, end = end, ref = ref, alt = alt)
  x <- annotation.cols.match(dat, "avsnp147", database.dir = database.dir, return.col.names = "avSNP147")
  x <- as.data.frame(x)
  expect_that(colnames(x), equals("avSNP147"))
  x[, 1] <- as.character(x[, 1])
  expect_that(x[1, 1], equals("rs775809821"))
  expect_that(is.na(x[2, 1]), equals(TRUE))
  expect_that(x[3, 1], equals("rs775809821"))
  x <- annotation.cols.match(dat, "avsnp147", database.dir = database.dir, return.col.names = "avSNP147", 
    db.type = "txt")
  x <- as.data.frame(x)
  expect_that(colnames(x), equals("avSNP147"))
  x[, 1] <- as.character(x[, 1])
  expect_that(x[1, 1], equals("rs775809821"))
  expect_that(is.na(x[2, 1]), equals(TRUE))
  expect_that(x[3, 1], equals("rs775809821"))
})

test_that("annotation.snp", {
  chr <- c("chr1", "chr2", "chr1")
  start <- c("10020", "10020", "10020")
  end <- c("10020", "10020", "10020")
  ref <- c("A", "A", "A")
  alt <- c("-", "-", "-")
  database.dir <- tempdir()
  dat <- data.table(chr = chr, start = start, end = end, ref = ref, alt = alt)
  x <- annotation(dat = dat, anno.name = "avsnp147", database.dir = database.dir)
  x <- as.data.frame(x)
  expect_that(colnames(x), equals("avSNP147"))
  x[, 1] <- as.character(x[, 1])
  expect_that(x[1, 1], equals("rs775809821"))
  expect_that(is.na(x[2, 1]), equals(TRUE))
  expect_that(x[3, 1], equals("rs775809821"))
  
})

test_that("annotation.1000g", {
  chr <- c("chr1", "chr2", "chr1")
  start <- c("10177", "10177", "10020")
  end <- c("10177", "10177", "10020")
  ref <- c("-", "A", "A")
  alt <- c("C", "AC", "-")
  dat <- data.table(chr = chr, start = start, end = end, ref = ref, alt = alt)
  x <- annotation(dat = dat, anno.name = "1000g2015aug_all", database.dir = database.dir)
  x <- as.data.frame(x)
  expect_that(colnames(x), equals("1000g2015aug_all"))
  x <- annotation(dat = dat, anno.name = "1000g2015aug_all", database.dir = database.dir, 
    return.col.names = "1000g2015aug_all_frq")
  x <- as.data.frame(x)
  expect_that(colnames(x), equals("1000g2015aug_all_frq"))
})

test_that("annotation:cosmic", {
  chr <- c("chr12", "chr2", "chr12")
  start <- c("11139001", "50850617", "11139002")
  end <- c("11139001", "50850617", "50850617")
  ref <- c("C", "G", "T")
  alt <- c("T", "A", "-")
  dat <- data.table(chr = chr, start = start, end = end, ref = ref, alt = alt)
  x <- annotation(dat = dat, anno.name = "cosmic81", database.dir = database.dir)
  x <- as.data.frame(x)
  expect_that(colnames(x), equals("COSMIC_81"))
  x[, 1] <- as.character(x[, 1])
  expect_that(x[1, 1], equals("ID=COSM4732228;OCCURENCE=1(large_intestine)"))
  expect_that(x[2, 1], equals("ID=COSM383974,COSM5973818,COSM383973,COSM5973817;OCCURENCE=1(upper_aerodigestive_tract),1(lung)"))
  expect_that(is.na(x[3, 1]), equals(TRUE))
})

test_that("annotation:snp", {
  chr <- c("chr1", "chr2", "chr1")
  start <- c("10020", "10020", "10020")
  end <- c("10020", "10020", "10020")
  ref <- c("A", "A", "A")
  alt <- c("-", "-", "-")
  dat <- data.table(chr = chr, start = start, end = end, ref = ref, alt = alt)
  x <- annotation(dat = dat, anno.name = "avsnp147", database.dir = database.dir)
  x <- as.data.frame(x)
  expect_that(colnames(x), equals("avSNP147"))
  x[, 1] <- as.character(x[, 1])
  expect_that(x[1, 1], equals("rs775809821"))
  expect_that(is.na(x[2, 1]), equals(TRUE))
  expect_that(x[3, 1], equals("rs775809821"))
})


test_that("annotation:RNA-editing", {
  # RADAR2
  chr <- c("1", "6", "1")
  start <- c("206256301", "116991832", "10020")
  dat <- data.table(chr = chr, start = start)
  x <- annotation(dat = dat, anno.name = "radar2", database.dir = database.dir)
  x <- as.data.frame(x)
  expect_that(colnames(x), equals("RADAR2.is.alu"))
  x[, 1] <- as.character(x[, 1])
  expect_that(x[1, 1], equals("no"))
  expect_that(x[2, 1], equals("no"))
  expect_that(is.na(x[3, 1]), equals(TRUE))
  
  # DAREND
  chr <- c("4", "4", "1")
  start <- c("250721", "475468", "10020")
  dat <- data.table(chr = chr, start = start)
  x <- annotation(dat = dat, anno.name = "darned", database.dir = database.dir)
  x <- as.data.frame(x)
  expect_that(colnames(x), equals("DARNED.in.rna"))
  x[, 1] <- as.character(x[, 1])
  expect_that(x[1, 1], equals("I"))
  expect_that(x[2, 1], equals("I"))
  expect_that(is.na(x[3, 1]), equals(TRUE))
})

test_that("annotation.normal.pool", {
  chr <- c("chr1", "chr1", "chr1")
  start <- c("13183511", "13183528", "10020")
  end <- c("13183511", "13183528", "10020")
  ref <- c("T", "A", "A")
  alt <- c("C", "C", "-")
  
  dat <- data.table(chr = chr, start = start, end = end, ref = ref, alt = alt)
  x <- annotation(dat = dat, anno.name = "2016sih_wes_ball", database.dir = database.dir)
  x <- as.data.frame(x)
  expect_that(colnames(x), equals("2016sih_wes_ball"))
  x[, 1] <- as.numeric(x[, 1])
  expect_that(x[1, 1], equals(200))
  expect_that(x[2, 1], equals(200))
  expect_that(is.na(x[3, 1]), equals(TRUE))
  x <- annotation(dat = dat, anno.name = "2016sih_wes_tall", database.dir = database.dir)
  x <- as.data.frame(x)
  expect_that(colnames(x), equals("2016sih_wes_tall"))
  x[, 1] <- as.numeric(x[, 1])
  expect_that(x[1, 1], equals(16))
  expect_that(x[2, 1], equals(16))
  expect_that(is.na(x[3, 1]), equals(TRUE))
  x <- annotation(dat = dat, anno.name = "2016sih_wes_nkt", database.dir = database.dir)
  x <- as.data.frame(x)
  expect_that(colnames(x), equals("2016sih_wes_nkt"))
  x[, 1] <- as.numeric(x[, 1])
  expect_that(x[1, 1], equals(25))
  expect_that(x[2, 1], equals(25))
  expect_that(is.na(x[3, 1]), equals(TRUE))
  x <- annotation(dat = dat, anno.name = "2016sih_wgs_nkt", database.dir = database.dir)
  x <- as.data.frame(x)
  expect_that(colnames(x), equals("2016sih_wgs_nkt"))
  x[, 1] <- as.numeric(x[, 1])
  expect_that(x[1, 1], equals(10))
  expect_that(x[2, 1], equals(10))
  expect_that(is.na(x[3, 1]), equals(TRUE))
  x <- annotation(dat = dat, anno.name = "2016sih_wgs_dlbcl", database.dir = database.dir)
  x <- as.data.frame(x)
  expect_that(colnames(x), equals("2016sih_wgs_dlbcl"))
  x[, 1] <- as.numeric(x[, 1])
  expect_that(x[1, 1], equals(16))
  expect_that(x[2, 1], equals(16))
  expect_that(is.na(x[3, 1]), equals(TRUE))
})

test_that("annotation.merge non-parallel:cosmic81 and snp147", {
  chr <- c("chr1", "chr2", "chr1", "chr12", "chr2", "chr12")
  start <- c("10020", "10020", "10020", "11139001", "50850617", "11139002")
  end <- c("10020", "10020", "10020", "11139001", "50850617", "50850617")
  ref <- c("A", "A", "A", "C", "G", "T")
  alt <- c("-", "-", "-", "T", "A", "-")
  dat <- data.table(chr = chr, start = start, end = end, ref = ref, alt = alt)
  x <- annotation.merge(anno.names = c("cosmic81", "avsnp147"), dat = dat, database.dir = database.dir)
  x <- as.data.frame(x)
  expect_that(colnames(x)[1], equals("COSMIC_81"))
  expect_that(colnames(x)[2], equals("avSNP147"))
  x[, 1] <- as.character(x[, 1])
  x[, 2] <- as.character(x[, 2])
  expect_that(is.na(x[1, 1]), equals(TRUE))
  expect_that(x[1, 2], equals("rs775809821"))
  expect_that(is.na(x[2, 1]), equals(TRUE))
  expect_that(is.na(x[2, 2]), equals(TRUE))
  expect_that(is.na(x[3, 1]), equals(TRUE))
  expect_that(x[3, 2], equals("rs775809821"))
})

test_that("clincvar and intervar", {
  chr <- c("chr1", "chr1", "chr1", "chr1", "chr1")
  start <- c("949523", "949696", "10020", "69095", "69096")
  end <- c("949523", "949696", "10020", "69095", "69096")
  ref <- c("C", "-", "A", "T", "G")
  alt <- c("T", "G", "-", "G", "A")
  dat <- data.table(chr = chr, start = start, end = end, ref = ref, alt = alt)
  x <- annotation.merge(anno.names = c("clinvar_20170130", "intervar_20170202"), 
    dat = dat, database.dir = database.dir)
  x <- as.data.frame(x)
  expect_that(colnames(x)[1], equals("clinvar_20170130"))
  expect_that(colnames(x)[2], equals("intervar_20170202"))
  expect_that(x[1, 1], equals("Pathogenic"))
  expect_that(x[2, 1], equals("Pathogenic"))
  expect_that(is.na(x[3, 1]), equals(TRUE))
  expect_that(is.na(x[4, 1]), equals(TRUE))
  expect_that(is.na(x[5, 1]), equals(TRUE))
  expect_that(x[4, 2], equals("Uncertain significance"))
  expect_that(x[5, 2], equals("Likely benign"))
  expect_that(is.na(x[1, 2]), equals(TRUE))
  expect_that(is.na(x[2, 2]), equals(TRUE))
  expect_that(is.na(x[3, 2]), equals(TRUE))
})

test_that("REDIportal", {
  chr <- c("chr1", "chr1", "chr1")
  start <- c("10255", "136168", "10020")
  ref <- c("A", "T", "A")
  alt <- c("G", "C", "G")
  dat <- data.table(chr = chr, start = start, ref = ref, alt = alt)
  x <- annotation(dat = dat, anno.name = "REDIportal", database.dir = database.dir, 
    db.type = "txt")
  x <- as.data.frame(x)
  expect_that(colnames(x), equals("REDIportal"))
  expect_that(x[1, 1], equals("R"))
  expect_that(x[2, 1], equals("A"))
  expect_that(is.na(x[3, 1]), equals(TRUE))
})
test_that("caddgt10", {
  chr <- c("chr1", "chr1", "chr1")
  start <- c("12066", "12066", "10020")
  end <- c("12066", "12066", "10020")
  ref <- c("T", "T", "A")
  alt <- c("A", "C", "G")
  dat <- data.table(chr = chr, start = start, end = end, ref = ref, alt = alt)
  x <- annotation(dat = dat, anno.name = "caddgt10", database.dir = database.dir, 
    db.type = "txt")
  x <- as.data.frame(x)
  expect_that(colnames(x)[1], equals("CADDgt10"))
  expect_that(colnames(x)[2], equals("CADDgt10_Phred"))
  expect_that(x[1, 1], equals("2.04979"))
  expect_that(x[2, 1], equals("1.934479"))
  expect_that(x[1, 2], equals("12.81"))
  expect_that(x[2, 2], equals("12.43"))
  expect_that(is.na(x[3, 1]), equals(TRUE))
})
test_that("caddgt20", {
  chr <- c("chr1", "chr1", "chr1")
  start <- c("35465", "35465", "10020")
  end <- c("35465", "35465", "10020")
  ref <- c("A", "A", "A")
  alt <- c("C", "T", "G")
  dat <- data.table(chr = chr, start = start, end = end, ref = ref, alt = alt)
  x <- annotation(dat = dat, anno.name = "caddgt20", database.dir = database.dir, 
    db.type = "txt")
  x <- as.data.frame(x)
  expect_that(colnames(x)[1], equals("CADDgt20"))
  expect_that(colnames(x)[2], equals("CADDgt20_Phred"))
  expect_that(x[1, 1], equals("4.396601"))
  expect_that(x[2, 1], equals("4.504534"))
  expect_that(x[1, 2], equals("23.3"))
  expect_that(x[2, 2], equals("24.2"))
  expect_that(is.na(x[3, 1]), equals(TRUE))
})

test_that("nci60", {
  chr <- c("chr1", "chr1", "chr1")
  start <- c("69270", "69428", "10020")
  end <- c("69270", "69428", "10020")
  ref <- c("A", "T", "A")
  alt <- c("G", "G", "G")
  dat <- data.table(chr = chr, start = start, end = end, ref = ref, alt = alt)
  x <- annotation(dat = dat, anno.name = "nci60", database.dir = database.dir, 
    db.type = "txt")
  x <- as.data.frame(x)
  expect_that(colnames(x)[1], equals("nci60"))
  expect_that(x[1, 1], equals("0.3"))
  expect_that(x[2, 1], equals("0.016"))
  expect_that(is.na(x[3, 1]), equals(TRUE))
})

test_that("icgc21", {
  chr <- c("chr1", "chr1", "chr1")
  start <- c("10002", "10072", "10020")
  end <- c("10002", "10072", "10020")
  ref <- c("A", "-", "A")
  alt <- c("T", "A", "G")
  dat <- data.table(chr = chr, start = start, end = end, ref = ref, alt = alt)
  x <- annotation(dat = dat, anno.name = "icgc21", database.dir = database.dir, 
    db.type = "txt")
  x <- as.data.frame(x)
  expect_that(colnames(x)[1], equals("icgc21_occurrence"))
  expect_that(x[1, 1], equals("MELA-AU|1|183|0.00546"))
  expect_that(x[2, 1], equals("PACA-CA|1|227|0.00441"))
  expect_that(is.na(x[3, 1]), equals(TRUE))
})

test_that("dbnsfp33a", {
  chr <- c("chr1", "chr1", "chr1")
  start <- c("69091", "69091", "10020")
  end <- c("69091", "69091", "10020")
  ref <- c("A", "A", "A")
  alt <- c("C", "G", "G")
  dat <- data.table(chr = chr, start = start, end = end, ref = ref, alt = alt)
  x <- annotation(dat = dat, anno.name = "dbnsfp30a", database.dir = database.dir, 
    db.type = "txt")
  x <- as.data.frame(x)
  expect_that(colnames(x)[1], equals("SIFT_score"))
  expect_that(colnames(x)[length(colnames(x))], equals("SiPhy_29way_logOdds"))
  expect_that(x[1, 1], equals("0.13"))
  expect_that(x[1, 2], equals("T"))
  expect_that(x[2, 1], equals("1.0"))
  expect_that(x[2, 2], equals("T"))
  expect_that(is.na(x[3, 1]), equals(TRUE))
  x <- annotation(dat = dat, anno.name = "dbnsfp33a", database.dir = database.dir, 
    db.type = "txt")
  x <- as.data.frame(x)
  expect_that(colnames(x)[1], equals("SIFT_score"))
  expect_that(colnames(x)[length(colnames(x))], equals("GTEx_V6_tissue"))
  expect_that(x[1, 1], equals("0.13"))
  expect_that(x[1, 3], equals("T"))
  expect_that(x[2, 1], equals("1.0"))
  expect_that(x[2, 3], equals("T"))
  expect_that(is.na(x[3, 1]), equals(TRUE))
  
  chr <- c("chr1", "chr1", "chr1")
  start <- c("69190", "69091", "10020")
  end <- c("69190", "69091", "10020")
  ref <- c("G", "A", "A")
  alt <- c("A", "G", "G")
  dat <- data.table(chr = chr, start = start, end = end, ref = ref, alt = alt)
  x <- annotation(dat = dat, anno.name = "dbnsfp31a_interpro", database.dir = database.dir, 
    db.type = "txt")
  x <- as.data.frame(x)
  expect_that(colnames(x)[1], equals("Interpro_domain"))
  expect_that(str_detect(x[1, 1], "^GPCR"), equals(TRUE))
  expect_that(str_detect(x[1, 1], "7TM$"), equals(TRUE))
  expect_that(is.na(x[3, 1]), equals(TRUE))
})

test_that("gme", {
  chr <- c("chr1", "chr1", "chr1")
  start <- c("69134", "69270", "10020")
  end <- c("69134", "69270", "10020")
  ref <- c("A", "A", "A")
  alt <- c("G", "G", "G")
  dat <- data.table(chr = chr, start = start, end = end, ref = ref, alt = alt)
  x <- annotation(dat = dat, anno.name = "gme", database.dir = database.dir, db.type = "txt")
  x <- as.data.frame(x)
  expect_that(colnames(x)[1], equals("GME_AF"))
  expect_that(x[1, 1], equals("0.049505"))
  expect_that(x[2, 1], equals("0.698113"))
  expect_that(is.na(x[3, 1]), equals(TRUE))
})

test_that("hrcr1", {
  chr <- c("chr1", "chr1", "chr1")
  start <- c("13380", "16071", "10020")
  end <- c("13380", "16071", "10020")
  ref <- c("C", "G", "A")
  alt <- c("G", "A", "G")
  dat <- data.table(chr = chr, start = start, end = end, ref = ref, alt = alt)
  x <- annotation(dat = dat, anno.name = "hrcr1", database.dir = database.dir, 
    db.type = "txt")
  x <- as.data.frame(x)
  expect_that(colnames(x)[2], equals("HRC_AC"))
  expect_that(x[1, 2], equals("5"))
  expect_that(x[2, 2], equals("8"))
  expect_that(is.na(x[3, 2]), equals(TRUE))
})

test_that("revel", {
  chr <- c("chr1", "chr1", "chr1")
  start <- c("35142", "35142", "10020")
  end <- c("35142", "35142", "10020")
  ref <- c("G", "G", "A")
  alt <- c("A", "C", "G")
  dat <- data.table(chr = chr, start = start, end = end, ref = ref, alt = alt)
  x <- annotation(dat = dat, anno.name = "revel", database.dir = database.dir, 
    db.type = "txt")
  x <- as.data.frame(x)
  expect_that(colnames(x)[1], equals("REVEL"))
  expect_that(x[1, 1], equals("0.027"))
  expect_that(x[2, 1], equals("0.035"))
  expect_that(is.na(x[3, 1]), equals(TRUE))
})

test_that("mcap", {
  chr <- c("chr1", "chr1", "chr1")
  start <- c("69091", "69092", "10020")
  end <- c("69091", "69092", "10020")
  ref <- c("A", "T", "A")
  alt <- c("T", "C", "G")
  dat <- data.table(chr = chr, start = start, end = end, ref = ref, alt = alt)
  x <- annotation(dat = dat, anno.name = "mcap", database.dir = database.dir, db.type = "txt")
  x <- as.data.frame(x)
  expect_that(colnames(x)[1], equals("MCAP"))
  expect_that(x[1, 1], equals("0.00708247797993"))
  expect_that(x[2, 1], equals("0.00326415452909"))
  expect_that(is.na(x[3, 1]), equals(TRUE))
})

test_that("exac03", {
  chr <- c("chr1", "chr1", "chr1")
  start <- c("13372", "13380", "10020")
  end <- c("13372", "13380", "10020")
  ref <- c("G", "C", "A")
  alt <- c("C", "G", "G")
  dat <- data.table(chr = chr, start = start, end = end, ref = ref, alt = alt)
  x <- annotation(dat = dat, anno.name = "exac03", database.dir = database.dir, 
    db.type = "txt")
  x <- as.data.frame(x)
  expect_that(colnames(x)[1], equals("ExAC_ALL"))
  x[, 1] <- formatC(as.numeric(x[, 1]))
  expect_that(x[1, 1], equals("0.0002"))
  expect_that(x[2, 1], equals("0.0033"))
  expect_that(x[3, 1], equals("NA"))
  
  x <- annotation(dat = dat, anno.name = "exac03nontcga", database.dir = database.dir, 
    db.type = "txt")
  x <- as.data.frame(x)
  expect_that(colnames(x)[1], equals("ExAC_nontcga_ALL"))
  x[, 1] <- formatC(as.numeric(x[, 1]))
  expect_that(x[1, 1], equals("0.0003"))
  expect_that(x[2, 1], equals("0.0024"))
  expect_that(x[3, 1], equals("NA"))
  
  x <- annotation(dat = dat, anno.name = "exac03nonpsych", database.dir = database.dir, 
    db.type = "txt")
  x <- as.data.frame(x)
  expect_that(colnames(x)[1], equals("ExAC_nonpsych_ALL"))
  x[, 1] <- formatC(as.numeric(x[, 1]))
  expect_that(x[1, 1], equals("0.0002"))
  expect_that(x[2, 1], equals("0.0034"))
  expect_that(x[3, 1], equals("NA"))
})

test_that("gnomad", {
  chr <- c("chr1", "chr1", "chr1")
  start <- c("12559", "12573", "10020")
  end <- c("12559", "12573", "10020")
  ref <- c("G", "T", "A")
  alt <- c("A", "C", "G")
  dat <- data.table(chr = chr, start = start, end = end, ref = ref, alt = alt)
  x <- annotation(dat = dat, anno.name = "gnomad_exome", database.dir = database.dir, 
    db.type = "txt")
  x <- as.data.frame(x)
  expect_that(colnames(x)[1], equals("gnomAD_exome_ALL"))
  x[, 1] <- formatC(as.numeric(x[, 1]))
  expect_that(x[1, 1], equals("0.0051"))
  expect_that(x[2, 1], equals("0.0005"))
  expect_that(x[3, 1], equals("NA"))
  
  chr <- c("chr1", "chr1", "chr1")
  start <- c("10109", "10108", "10020")
  end <- c("10114", "10114", "10020")
  ref <- c("AACCCT", "CAACCCT", "A")
  alt <- c("-", "C", "G")
  dat <- data.table(chr = chr, start = start, end = end, ref = ref, alt = alt)
  x <- annotation(dat = dat, anno.name = "gnomad_genome", database.dir = database.dir, 
    db.type = "txt")
  x <- as.data.frame(x)
  expect_that(colnames(x)[1], equals("gnomAD_genome_ALL"))
  x[, 1] <- formatC(as.numeric(x[, 1]))
  expect_that(x[1, 1], equals("0.001"))
  expect_that(x[2, 1], equals("0.001"))
  expect_that(x[3, 1], equals("NA"))
})

test_that("gwava", {
  chr <- c("chr1", "chr1", "chr1")
  start <- c("10177", "10180", "10020")
  end <- c("10177", "10180", "10020")
  ref <- c("A", "T", "A")
  alt <- c("C", "A", "G")
  dat <- data.table(chr = chr, start = start, end = end, ref = ref, alt = alt)
  x <- annotation(dat = dat, anno.name = "gwava", database.dir = database.dir, 
    db.type = "txt")
  x <- as.data.frame(x)
  expect_that(colnames(x)[1], equals("GWAVA_region_score"))
  expect_that(x[1, 1], equals("0.47"))
  expect_that(x[2, 1], equals("0.5"))
  expect_that(is.na(x[3, 1]), equals(TRUE))
})

test_that("kaviar", {
  chr <- c("chr1", "chr1", "chr1")
  start <- c("10001", "10002", "10020")
  end <- c("10001", "10002", "10020")
  ref <- c("T", "A", "A")
  alt <- c("C", "T", "G")
  dat <- data.table(chr = chr, start = start, end = end, ref = ref, alt = alt)
  x <- annotation(dat = dat, anno.name = "kaviar_20150923", database.dir = database.dir, 
    db.type = "txt")
  x <- as.data.frame(x)
  expect_that(colnames(x)[1], equals("Kaviar_AF"))
  expect_that(x[1, 1], equals("3.84e-05"))
  expect_that(x[2, 1], equals("3.84e-05"))
  expect_that(is.na(x[3, 1]), equals(TRUE))
})
test_that("popfreq", {
  chr <- c("chr1", "chr1", "chr1")
  start <- c("10177", "10235", "10020")
  end <- c("10177", "10235", "10020")
  ref <- c("-", "-", "A")
  alt <- c("C", "A", "G")
  dat <- data.table(chr = chr, start = start, end = end, ref = ref, alt = alt)
  x <- annotation(dat = dat, anno.name = "popfreq_all_20150413", database.dir = database.dir, 
    db.type = "txt")
  x <- as.data.frame(x)
  expect_that(colnames(x)[1], equals("PopFreqMax"))
  expect_that(x[1, 1], equals("0.49"))
  expect_that(x[2, 1], equals("0.0051"))
  expect_that(is.na(x[3, 1]), equals(TRUE))
  
  chr <- c("chr1", "chr1", "chr1")
  start <- c("10177", "10235", "10020")
  end <- c("10177", "10235", "10020")
  ref <- c("-", "-", "A")
  alt <- c("C", "A", "G")
  dat <- data.table(chr = chr, start = start, end = end, ref = ref, alt = alt)
  x <- annotation(dat = dat, anno.name = "popfreq_max_20150413", database.dir = database.dir, 
    db.type = "txt")
  x <- as.data.frame(x)
  expect_that(colnames(x), equals("PopFreqMax"))
  expect_that(x[1, 1], equals("0.49"))
  expect_that(x[2, 1], equals("0.0051"))
  expect_that(is.na(x[3, 1]), equals(TRUE))
})

test_that("eigen", {
  chr <- c("chr1", "chr1", "chr1")
  start <- c("10001", "10002", "10020")
  end <- c("10001", "10002", "10021")
  ref <- c("T", "A", "A")
  alt <- c("G", "C", "GG")
  dat <- data.table(chr = chr, start = start, end = end, ref = ref, alt = alt)
  x <- annotation(dat = dat, anno.name = "eigen", database.dir = database.dir, 
    db.type = "txt")
  x <- as.data.frame(x)
  expect_that(colnames(x), equals("Eigen"))
  expect_that(x[1, 1], equals("-0.3078"))
  expect_that(x[2, 1], equals("-0.3078"))
  expect_that(is.na(x[3, 1]), equals(TRUE))
  
})

for (i in c("hg19_avsnp147", "hg19_cosmic81", "hg19_ALL.sites.2015_08", 
  "hg19_RADAR2", "hg19_DARNED", "hg19_normal2016sih_wes_ball", "hg19_normal2016sih_wes_nkt", 
  "hg19_normal2016sih_wes_tall", "hg19_normal2016sih_wgs_nkt", "hg19_normal2016sih_wgs_dlbcl", 
  "hg19_clinvar_20170130", "hg19_intervar_20170202", "hg19_REDIportal", "hg19_caddgt10", 
  "hg19_nci60", "hg19_icgc21", "hg19_dbnsfp30a", "hg19_dbnsfp33a", "hg19_dbnsfp31a_interpro", 
  "hg19_gme", "hg19_hrcr1", "hg19_revel", "hg19_mcap", "hg19_exac03", "hg19_exac03nontcga", 
  "hg19_exac03nonpsych", "hg19_gnomad_exome", "hg19_gnomad_genome", "hg19_gwava", 
  "hg19_kaviar_20150923", "hg19_popfreq_all_20150413", "hg19_popfreq_max_20150413", 
  "hg19_eigen", "hg19_caddgt20")) {
  sqlite.db <- sprintf("%s/%s.sqlite", tempdir(), i)
  txt.db <- sprintf("%s/%s.txt", tempdir(), i)
  sqlite.db <- normalizePath(sqlite.db, "/")
  txt.db <- normalizePath(txt.db, "/")
  file.remove(sqlite.db)
  file.remove(txt.db)
}
