% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_layout.R
\name{mapLayout}
\alias{mapLayout}
\title{Place areas of a study on a map}
\usage{
mapLayout(layout, what = c("areas", "districts"), map = getSpMaps(),
  map_builder = TRUE)
}
\arguments{
\item{layout}{object returned by function \code{\link[antaresRead]{readLayout}}}

\item{what}{Either "areas" or "districts". Indicates what type of object to place
on the map.}

\item{map}{An optional \code{\link[sp]{SpatialPolygons}} or 
\code{\link[sp]{SpatialPolygonsDataFrame}} object. See \code{\link[spMaps]{getSpMaps}}}

\item{map_builder}{\code{logical} Add inputs for build custom map ? Defaut to TRUE.}
}
\value{
An object of class \code{mapLayout}.
}
\description{
This function launches an interactive application that let the user place 
areas of a study on a map. the GPS coordinates of the areas are then returned
and can be used in functions. This function should be used only once per 
study. The result should then be saved in an external file and be reused.
}
\examples{
\dontrun{
# Read the coordinates of the areas in the Antares interface, then convert it
# in a map layout.
layout <- readLayout()
ml <- mapLayout(layout)

# visualize mapLayout
plotMapLayout(ml)

# Save the result for future use
save(ml, file = "ml.rda")

}

}
\seealso{
\code{\link{plotMapLayout}}
}
