% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_airports.R
\name{get_airports}
\alias{get_airports}
\title{Generate an airports dataset}
\source{
\url{http://openflights.org/data.html}
}
\usage{
get_airports(dir)
}
\arguments{
\item{dir}{A character string---the folder for the dataset to be saved in}
}
\value{
A data frame with ~1350 rows and 8 variables:
\describe{
 \item{faa}{FAA airport code}
 \item{name}{Usual name of the airport}
 \item{lat,lon}{Location of airport}
 \item{alt}{Altitude, in feet}
 \item{tz}{Timezone offset from GMT}
 \item{dst}{Daylight savings time zone. A = Standard US DST: starts on the
    second Sunday of March, ends on the first Sunday of November.
    U = unknown. N = no dst.}
 \item{tzone}{IANA time zone, as determined by GeoNames webservice}
}
}
\description{
Please note that, even with a strong internet connection, this function 
may take several minutes to download relevant data.
}
\examples{
\donttest{get_airports(dir = tempdir())}
}
\seealso{
\code{\link{get_flights}} for flight data, \code{\link{get_weather}}
for weather data, \code{\link{get_airlines}} for airline
data, and \code{\link{anyflights}} for a wrapper function
}
