% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formats.R
\name{iso8601}
\alias{iso8601}
\alias{rfc2822}
\alias{rfc3339}
\alias{yyyymmdd}
\title{Format a Datetime object: ISO 8601, RFC 2822 or RFC 3339}
\usage{
iso8601(pt)

rfc2822(pt)

rfc3339(pt)

yyyymmdd(pt)
}
\arguments{
\item{pt}{A \code{POSIXt} Datetime or a \code{Date} object}
}
\value{
A character object formatted according to ISO 8601, RFC 2822 or RFC 3339
}
\description{
ISO 8601, RFC 2822 and RFC 3339 are a standards for date and time representation covering the
formatting of date and time (with or without possible fractional seconds) and timezone
information.
}
\section{ISO 8601}{

ISO 8601 is described in some detail in \url{https://en.wikipedia.org/wiki/ISO_8601} and covers
multiple date and time formats.

Here, we interpret it more narrowly focussing on a single format each for datetimes
and dates.  We return datetime object formatted as \sQuote{2016-09-01T10:11:12}
and date object as \sQuote{2016-09-01}.

If the option \code{anytime.oldISO8601format} is set to \code{TRUE}, then the previous
format (with a space instead of \sQuote{T} to separate date and time) is used.
}

\section{RFC 2822}{

RFC 2822 is described in some detail in \url{https://www.ietf.org/rfc/rfc2822.txt}
and \url{https://en.wikipedia.org/wiki/Email#Internet_Message_Format}.  The Date and Time
formating cover only a subset of the specification in that RFC.

Here, we use it to provide a single format each for datetimes
and dates.  We return datetime object formatted as
\sQuote{Thu, 01 Sep 2016 10:11:12.123456 -0500}
and date object as \sQuote{Thu, 01 Sep 2016}.
}

\section{RFC 3339}{

RFC 3339 is described in some detail in \url{https://tools.ietf.org/html/rfc3339}
It refines both earlier standards.

Here, we use it to format datetimes and dates as single and compact strings.
We return datetime object formatted as \sQuote{2016-09-01T10:11:12.123456-0500}
and date object as \sQuote{2016-09-01}.
}

\section{YYYYMMDD}{

This is a truly terrible format which needs to die, but refuses to do so.  If you
are unfortunate enough to be forced to interoperate with code expecting it, you
can use this function. But it would be better to take a moment to rewrite such code.
}

\examples{
iso8601(anytime("2016-09-01 10:11:12.123456"))
iso8601(anydate("2016-Sep-01"))

rfc2822(anytime("2016-09-01 10:11:12.123456"))
rfc2822(anydate("2016-Sep-01"))

rfc3339(anytime("2016-09-01 10:11:12.123456"))
rfc3339(anydate("2016-Sep-01"))

yyyymmdd(anytime("2016-09-01 10:11:12.123456"))
yyyymmdd(anydate("2016-Sep-01"))
}
\references{
\url{https://en.wikipedia.org/wiki/ISO_8601},
\url{https://www.ietf.org/rfc/rfc2822.txt},
\url{https://en.wikipedia.org/wiki/Email#Internet_Message_Format},
\url{https://tools.ietf.org/html/rfc3339}
}
\author{
Dirk Eddelbuettel
}
