% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_interface.R
\name{spark_write_geojson}
\alias{spark_write_geojson}
\alias{spark_write_geoparquet}
\alias{spark_write_raster}
\title{Write geospatial data from a Spark DataFrame.}
\usage{
spark_write_geojson(
  x,
  path,
  mode = NULL,
  options = list(),
  partition_by = NULL,
  ...
)

spark_write_geoparquet(
  x,
  path,
  mode = NULL,
  options = list(),
  partition_by = NULL,
  ...
)

spark_write_raster(
  x,
  path,
  mode = NULL,
  options = list(),
  partition_by = NULL,
  ...
)
}
\arguments{
\item{x}{A Spark DataFrame or dplyr operation}

\item{path}{The path to the file. Needs to be accessible from the cluster.
Supports the \samp{"hdfs://"}, \samp{"s3a://"} and \samp{"file://"} protocols.}

\item{mode}{A \code{character} element. Specifies the behavior when data or
  table already exists. Supported values include: 'error', 'append', 'overwrite' and
  ignore. Notice that 'overwrite' will also change the column structure.

  For more details see also \url{https://spark.apache.org/docs/latest/sql-programming-guide.html}
  for your version of Spark.}

\item{options}{A list of strings with additional options.}

\item{partition_by}{A \code{character} vector. Partitions the output by the given columns on the file system.}

\item{...}{Optional arguments; currently unused.}
}
\description{
Functions to write geospatial data into a variety of formats from Spark DataFrames.
\itemize{
\item \code{spark_write_geojson}: to GeoJSON
\item \code{spark_write_geoparquet}: to GeoParquet
\item \code{spark_write_raster}: to raster tiles after using RS output functions (\code{RS_AsXXX})
}
}
\examples{
library(sparklyr)
library(apache.sedona)

sc <- spark_connect(master = "spark://HOST:PORT")

if (!inherits(sc, "test_connection")) {
  tbl <- dplyr::tbl(
    sc,
    dplyr::sql("SELECT ST_GeomFromText('POINT(-71.064544 42.28787)') AS `pt`")
  )
  spark_write_geojson(
    tbl \%>\% dplyr::mutate(id = 1),
    output_location = "/tmp/pts.geojson"
  )
}

}
\seealso{
Other Sedona DF data interface functions: 
\code{\link{spark_read_shapefile}()}
}
\concept{Sedona DF data interface functions}
