% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.fv_pcf.R
\name{plot.fv_pcf}
\alias{plot.fv_pcf}
\title{Plot PCF}
\usage{
\method{plot}{fv_pcf}(x, xlim = NULL, ylim = NULL, xticks = NULL,
  yticks = NULL, xlab = "r", ylab = "g(r)", main = NULL,
  sub = NULL, xaxis = TRUE, yaxis = TRUE,
  ann = graphics::par("ann"), bty = "l", ...)
}
\arguments{
\item{x}{an object of class \link{fv_pcf}.}

\item{xlim, ylim}{the x and y limits of the plot. NULL indicates that the
range of the finite values to be plotted should be used.}

\item{xticks, yticks}{points at which tick-marks are to be drawn.
By default (when NULL) tickmark locations are computed}

\item{xlab, ylab}{a label for the x and y axis, respectively.}

\item{main, sub}{a main and sub title for the plot, see also \code{\link[=title]{title()}}.}

\item{xaxis, yaxis}{a logical value or a 1-character string giving the
desired type of axis. The following values are possible: "n" or FALSE
for no axis, "t" for ticks only, "f" or TRUE for full axis, "o" for
full axis in the outer margin.}

\item{ann}{a logical value indicating whether the default annotation
(title and x and y axis labels) should appear on the plot.}

\item{bty}{a character string which determines the type of box which is
drawn about the plotting region, see \code{\link[=par]{par()}}.}

\item{...}{additional parameter, currently without effect}
}
\value{
An object of class \link{fv_pcf} invisibly.
}
\description{
Plot method for the class "fv_pcf". Draws a pair correlation function and
a pointwise critical envelope if available.
}
\examples{
# it's advised against setting n_sim < 199
ds <- pat2dists(area=system.file("shapes/sim_area.shp", package="apcf"),
                pattern=system.file("shapes/sim_pat_reg.shp", package="apcf"),
                max_dist=25, n_sim=3)

# derive PCF and envelope
pcf <- dists2pcf(ds, r=0.2, r_max=25, stoyan=0.15, n_rank=1)

# a simple plot
plot(x=pcf, xlim=c(0, 20), ylim=c(0, 2.2))

# a panel of four plots
op <- par(mfrow=c(2,2), oma=c(3,3,0,0), mar=c(0,0,2,2),
          mgp=c(2,0.5,0), tcl=-0.3)
plot(pcf, xaxis='t', yaxis='o', ann=FALSE)
plot(pcf, xaxis='t', yaxis='t', ann=FALSE)
plot(pcf, xaxis='o', yaxis='o', ann=FALSE)
plot(pcf, xaxis='o', yaxis='t')
par(op)

}
\seealso{
\code{\link[=pat2dists]{pat2dists()}}, \code{\link[=dists2pcf]{dists2pcf()}}
}
