% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pat2dists.R
\name{pat2dists}
\alias{pat2dists}
\title{Convert a Pattern to Distances & Ratios}
\usage{
pat2dists(area, pattern, max_dist, n_sim = 199, max_tries = 1e+05,
  save_patterns = NULL, verbose = FALSE)
}
\arguments{
\item{area, pattern}{Data source name of study area and pattern
(interpretation varies by driver - for some drivers, dsn is a file
name, but may also be a folder, or contain the name and access
credentials of a database)}

\item{max_dist}{Maximum distance measured in the pattern. Usually smaller
than half the diameter of the study area.}

\item{n_sim}{Number of simulated patterns (randomizations) to be generated
for computing the envelope and correcting the biased emperical pcf.
Determines together with \code{n_rank} in \code{\link[=dists2pcf]{dists2pcf()}} the alpha level of
the envelope. If \code{alpha} and \code{n_rank} are fix, n_sim can be
calculated by \code{(n_rank*2/alpha)-1} eg. \code{(5*2/0.05)-1 = 199}.}

\item{max_tries}{How often shall a relocation of an object be tried
while randomizing the pattern.}

\item{save_patterns}{Shall the simulated patterns be saved as Shapefiles
for debugging/later inspections. Might be a large number of files
(4 * n_sim). Can be \code{NULL} (no export) or a character string
providing a basename optionally including a valid/existing path.}

\item{verbose}{Provide progress information in the console. Roman numerals
(x: 10, C: 100, D: 500, M: 1000) indicate the progress of the
simulation and 'e' the emperical PCF.}
}
\value{
An object of class \link{dists}.
}
\description{
Creates \code{n_sim} null models by permutation of the original pattern and
calculates distances between all object of a pattern closer than \code{max_dist}
and determines the fractions of the perimeter of buffers with distance
\code{dist} inside the study area (needed for edge correction).
}
\details{
Null models are created by randomly rotating and randomly placing all
objects within the study area without overlap. They are used for correcting
the biased pcf and constructing a pointwise critical envelope (cf. Nuske
et al. 2009).

Measuring distances between objects and permutation of the pattern is done
with \href{https://trac.osgeo.org/geos}{GEOS} and spatial data are converted to
GEOS geometries by \href{http://www.gdal.org}{GDAL/OGR}.
}
\examples{
# it's advised against setting n_sim < 199
ds <- pat2dists(area=system.file("shapes/sim_area.shp", package="apcf"),
                pattern=system.file("shapes/sim_pat_reg.shp", package="apcf"),
                max_dist=25, n_sim=3, verbose=TRUE)

}
\references{
Nuske, R.S., Sprauer, S. and Saborowski J. (2009)
Adapting the pair-correlation function for analysing the spatial
distribution of canopy gaps.
\emph{Forest Ecology and Management}, \bold{259}(1), 107-–116.
\doi{10.1016/j.foreco.2009.09.050}
}
\seealso{
\code{\link[=dists2pcf]{dists2pcf()}}, \code{\link[=plot.fv_pcf]{plot.fv_pcf()}}
}
