% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apex-utils.R
\name{ax_markers}
\alias{ax_markers}
\title{Markers properties}
\usage{
ax_markers(ax, size = NULL, colors = NULL, strokeColor = NULL,
  strokeWidth = NULL, strokeOpacity = NULL, fillOpacity = NULL,
  shape = NULL, radius = NULL, offsetX = NULL, offsetY = NULL,
  hover = NULL, ...)
}
\arguments{
\item{ax}{A \code{apexcharts} \code{htmlwidget} object.}

\item{size}{Numeric. Size of the marker point.}

\item{colors}{Sets the fill color(s) of the marker point.}

\item{strokeColor}{Stroke Color of the marker.}

\item{strokeWidth}{Stroke Size of the marker.}

\item{strokeOpacity}{Opacity of the border around marker.}

\item{fillOpacity}{Opacity of the marker fill color.}

\item{shape}{Shape of the marker. Available Options for shape: \code{"square"} or \code{"circle"}.}

\item{radius}{Numeric. Radius of the marker (applies to square shape)}

\item{offsetX}{Numeric. Sets the left offset of the marker.}

\item{offsetY}{Numeric. Sets the top offset of the marker.}

\item{hover}{List with item \code{size} (Size of the marker when it is active).}

\item{...}{Additional parameters.}
}
\value{
A \code{apexcharts} \code{htmlwidget} object.
}
\description{
Markers properties
}
\note{
See \url{https://apexcharts.com/docs/options/markers/}
}
\examples{
data("economics", package = "ggplot2")

# show points
apex(
  data = tail(economics, 20),
  type = "line", 
  mapping = aes(x = date, y = uempmed)
) \%>\% 
  ax_markers(size = 6) 
}
