% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_logLik.R
\name{plot_multivariate}
\alias{plot_multivariate}
\title{Multiavariate plot (surface)}
\usage{
plot_multivariate(
  fun,
  params,
  domain,
  sets,
  nlevels = 20,
  args = list(),
  plotfun = graphics::image,
  plot = TRUE,
  postplot = function(params, res) {     points(params, cex = 2, pch = 3, col = "red")
    },
  mfrow = NULL,
  ...
)
}
\arguments{
\item{fun}{A function that receives 2 or more parameters and returns a single
number.}

\item{params}{Numeric vector with the default parameters.}

\item{domain}{(optional) Named list with as many elements as parameters. Specifies the
domain of the function.}

\item{sets}{(optional) Character matrix of size \verb{2 x # of combinations}.
contains the names of the pairs to plot. If nothing passed, the function will
generate all possible combinations as \code{combn(names(params), 2)}.}

\item{nlevels}{Integer. Number of levels.}

\item{args}{List of named arguments to be passed to \code{fun}.}

\item{plotfun}{Function that will be used to plot \verb{x,y,z}.}

\item{plot}{Logical. When \code{FALSE} skips plotting.}

\item{postplot}{Function to be called after \code{plotfun}. Should recieve a vector
with the current parameters.}

\item{mfrow}{Passed to \link[graphics:par]{graphics::par}.}

\item{...}{Further arguments passed to \code{plotfun}.}
}
\value{
A list of length \code{length(sets)}, each with the following:
\itemize{
\item x,y,z vectors of coordinates.
\item xlab,ylab vectors with the corresponding labels.
}
}
\description{
Multiavariate plot (surface)
}
\examples{
# Example: A model with less parameters
set.seed(1231)
x <- raphylo(20)
ans <- aphylo_mcmc(
  x ~ psi + mu_d + mu_s,
  control = list(nsteps = 1e3, burnin = 0)
  )

# Creating the multivariate plot (using by default image)
plot_multivariate(
  function(...) {
    ans$fun(unlist(list(...)), priors = ans$priors, dat = ans$dat, verb_ans = FALSE)
  },
  sets = matrix(c("mu_d0", "mu_d1", "psi0", "psi1"), ncol=2),
  params = ans$par
)
}
