% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_readBeta.R
\name{apollo_readBeta}
\alias{apollo_readBeta}
\title{Reads parameters from file}
\usage{
apollo_readBeta(
  apollo_beta,
  apollo_fixed,
  inputModelName,
  overwriteFixed = FALSE
)
}
\arguments{
\item{apollo_beta}{Named numeric vector. Names and values for parameters.}

\item{apollo_fixed}{Character vector. Names (as defined in \code{apollo_beta}) of parameters whose value should not change during estimation.}

\item{inputModelName}{Character. modelName for model from which results are used as starting values.}

\item{overwriteFixed}{Boolean. TRUE if starting values for fixed parameters should also be updated from input file.}
}
\value{
Named numeric vector. Names and updated starting values for parameters.
}
\description{
Reads in parameters from a previously estimated model and copies the values to the given apollo_beta vector, only for those parameters whose name matches.
}
\details{
This function will update the values of the parameters in its argument \code{apollo_beta} with the matching values in the file
\code{(inputModelName)_estimates.csv}. If there is no match for a given parameter in \code{apollo_beta}, its value will not be updated.
}
\examples{
### Define starting values and fixed parameters
apollo_beta <- c(asc1=0, asc2=0, b1=0, b2=0)
apollo_fixed <- c("asc1")
\dontrun{
## Not run:
### Update starting values
apollo_beta <- apollo_readBeta(apollo_beta, apollo_fixed, 
                               "oldModelName", overwriteFixed=FALSE)
## End(Not run)
}
}
