% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_mnl.R
\name{apollo_mnl}
\alias{apollo_mnl}
\title{Calculates Multinomial Logit probabilities}
\usage{
apollo_mnl(mnl_settings, functionality)
}
\arguments{
\item{mnl_settings}{List of inputs of the MNL model. It should contain the following.
\itemize{
  \item \strong{\code{alternatives}}: Named numeric vector. Names of alternatives and their corresponding value in \code{choiceVar}.
  \item \strong{\code{avail}}: Named list of numeric vectors or scalars. Availabilities of alternatives, one element per alternative. Names of elements must match those in \code{alternatives}. Values can be 0 or 1.
  \item \strong{\code{choiceVar}}: Numeric vector. Contains choices for all observations. It will usually be a column from the database. Values are defined in \code{alternatives}.
  \item \strong{\code{V}}: Named list of deterministic utilities . Utilities of the alternatives. Names of elements must match those in \code{alternatives.}
  \item \strong{\code{rows}}: Boolean vector. Consideration of rows in the likelihood calculation, FALSE to exclude. Length equal to the number of observations (nObs). Default is \code{"all"}, equivalent to \code{rep(TRUE, nObs)}.
  \item \strong{\code{componentName}}: Character. Name given to model component.
}}

\item{functionality}{Character. Can take different values depending on desired output.
\itemize{
  \item \code{"estimate"}: Used for model estimation.
  \item \code{"prediction"}: Used for model predictions.
  \item \code{"validate"}: Used for validating input.
  \item \code{"zero_LL"}: Used for calculating null likelihood.
  \item \code{"shares_LL"}: Used for calculating likelihood with constants only.
  \item \code{"conditionals"}: Used for calculating conditionals.
  \item \code{"output"}: Used for preparing output after model estimation.
  \item \code{"raw"}: Used for debugging.
}}
}
\value{
The returned object depends on the value of argument \code{functionality} as follows.
        \itemize{
          \item \strong{\code{"estimate"}}: vector/matrix/array. Returns the probabilities for the chosen alternative for each observation.
          \item \strong{\code{"prediction"}}: List of vectors/matrices/arrays. Returns a list with the probabilities for all alternatives, with an extra element for the probability of the chosen alternative.
          \item \strong{\code{"validate"}}: Same as \code{"estimate"}, but it also runs a set of tests to validate the function inputs.
          \item \strong{\code{"zero_LL"}}: vector/matrix/array. Returns the probability of the chosen alternative when all parameters are zero.
          \item \strong{\code{"shares_LL"}}: vector/matrix/array. Returns the probability of the chosen alternative when only constants are estimated.
          \item \strong{\code{"conditionals"}}: Same as \code{"estimate"}
          \item \strong{\code{"output"}}: Same as \code{"estimate"} but also writes summary of input data to internal Apollo log.
          \item \strong{\code{"raw"}}: Same as \code{"prediction"}
        }
}
\description{
Calculates probabilities of a Multinomial Logit model.
}
