% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_longToWide.R
\name{apollo_longToWide}
\alias{apollo_longToWide}
\title{Converts data from long to wide format.}
\usage{
apollo_longToWide(longData, longToWide_settings)
}
\arguments{
\item{longData}{data.frame. Data in long format.}

\item{longToWide_settings}{List. Contains settings for this function. User input is required for all settings. 
\itemize{
  \item \strong{\code{alternative_column}}: Character. Name of column in long data that contains the names of the alternatives (either numeric or character).
  \item \strong{\code{alternative_specific_attributes}}: Character vector. Names of columns in long data with attributes that vary across alternatives within an observation.
  \item \strong{\code{choice_column}}: Character. Name of column in long data that contains the choice.
  \item \strong{\code{ID_column}}: Character. Name of column in long data that contains the ID of individuals.
  \item \strong{\code{observation_column}}: Character. Name of column in long data that contains the observation index.
}}
}
\value{
Silently returns a data.frame with the wide format version of the data.
        An overview of the data is printed to screen.
}
\description{
Converts choice data from long to wide format, with one row per observation as opposed to one row per alternative/observation.
}
