% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/runAPSIM.R
\name{apsim}
\alias{apsim}
\title{Run APSIM Simulations from R}
\usage{
apsim(exe, wd = getwd(), files = NULL)
}
\arguments{
\item{exe}{path to the APSIM executable}

\item{wd}{working directory containing the .apsim files to be run; defaults to the current working directory}

\item{files}{.apsim files to be run; if left empty all .apsim files in \code{wd} will be run}
}
\value{
list of output files; each element corresponds to an .apsim file
}
\description{
This function will run one or many APSIM simulations and read the output into R
in the form of a list.  If the simulation does not run for some reason then
an error is returned.
}
\details{
The only required input is the path to the APSIM executable (APSIM.exe) usually found in the "Model"
subfolder of the APSIM installation. By default, it is assumed the current working directory contains the .apsim file(s)
to be run.  If that is not the case then the directory containing the .apsim file(s) to be run
should be specified by \code{wd}.  One can specify a list of .apsim files to be run within the
directory \code{wd} using the \code{files} argument.  If the \code{files} argument is left blank then all
.apsim files within the directory specified by \code{wd} are run.
The results for each .apsim file that is run is an element of the list that is returned.
Each element of the list is of the class \code{"apsim"}, which has its own \code{print} and \code{plot} routines.
}
\examples{
\dontrun{
apsimExe <-"C:/Program Files (x86)/Apsim75-r3008/Model/Apsim.exe"
apsimWd <- "~/APSIM"
toRun <- c("Centro.apsim", "Continuous Wheat.apsim")
results <- apsim(exe = apsimExe, wd = apsimWd, files = toRun)
results
plot(results$Centro)
}
}

