% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apsim_met.R
\name{add_column_apsim_met}
\alias{add_column_apsim_met}
\alias{$<-.met}
\alias{remove_column_apsim_met}
\title{Add a column to an object of class \sQuote{met}}
\usage{
add_column_apsim_met(met, value, name, units)

\method{$}{met}(x, name) <- value

remove_column_apsim_met(met, name)
}
\arguments{
\item{met}{object of class \sQuote{met}}

\item{value}{value for the data.frame. It could be an integer, double or vector of length equal to the number of rows in x.}

\item{name}{name of the variable to be removed}

\item{units}{units for the new column (required)}

\item{x}{object of class \sQuote{met}}
}
\value{
an object of class \sQuote{met} with the additional column

an object of class \sQuote{met} without the variable (column) in \sQuote{name}
}
\description{
The usual way of adding a column to a data frame might
not work for an object of class \sQuote{met}, so this method is recommended
}
\examples{
\donttest{
extd.dir <- system.file("extdata", package = "apsimx")
ames <- read_apsim_met("Ames.met", src.dir = extd.dir)

## The recommended method is
val <- abs(rnorm(nrow(ames), 10))
ames <- add_column_apsim_met(ames, value = val, name = "vp", units = "(hPa)")

## This is also possible
vp <- data.frame(vp = abs(rnorm(nrow(ames), 10)))
attr(vp, "units") <- "(hPa)"
ames$vp <- vp

## This is needed to ensure that units and related attributes are also removed
ames <- remove_column_apsim_met(ames, "vp")
## However, ames$vp <- NULL will also work
}


}
