% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\docType{data}
\name{munsell}
\alias{munsell}
\title{Munsell to sRGB Lookup Table for Common Soil Colors}
\format{
A data frame with 8825 rows.  \describe{ \item{hue}{Munsell
Hue, upper case} \item{value}{Munsell Value}
\item{chroma}{Munsell Chroma} \item{r}{sRGB "red" value
(0-1)} \item{g}{sRGB "green" value (0-1)} \item{b}{sRGB
"blue" value (0-1)} \item{L}{CIE LAB "L" coordinate}
\item{A}{CIE LAB "A" coordinate} \item{B}{CIE LAB "B"
coordinate} }
}
\source{
Color chip XYZ values:
http://www.rit.edu/cos/colorscience/rc_munsell_renotation.php
}
\usage{
data(munsell)
}
\description{
A lookup table of interpolated Munsell color chips for common soil colors.
}
\details{
See \code{munsell2rgb} for conversion examples. Note that this table does
not currently have entires for values of 2.5--common in most soil color
books. These chips should be added in the next major release of aqp. Values
are referenced to the D65 standard illuminant.
}
\examples{

data(munsell)

}
\references{
\describe{
\item{http://www.brucelindbloom.com/index.html?ColorCalcHelp.html}{Color
conversion equations}
\item{http://dx.doi.org/10.1016/j.cageo.2012.10.020}{Methods used to
generate this table} }
}
\keyword{datasets}
