% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glomApply.R
\name{trunc,SoilProfileCollection-method}
\alias{trunc,SoilProfileCollection-method}
\alias{trunc}
\title{Truncate a SoilProfileCollection to specified top and bottom depth}
\usage{
\S4method{trunc}{SoilProfileCollection}(x, z1, z2)
}
\arguments{
\item{x}{A SoilProfileCollection}

\item{z1}{Upper boundary}

\item{z2}{Lower boundary}
}
\value{
A SoilProfileCollection truncated to interval \code{[z1, z2]}
}
\description{
\code{trunc} is a wrapper method around \code{glomApply} for the case when the same top and bottom depth is required for all profiles in a collection. In contrast, \code{glomApply} allows for arbitrary functions to be run on each profile to calculate a unique set of depths.
}
\examples{

# load sample data
data("sp3")

# promote to SPC
depths(sp3) <- id ~ top + bottom

### TRUNCATE all profiles in sp3 to [0,25]

# set up plot parameters
par(mfrow=c(2,1), mar=c(0,0,0,0))

# full profiles
plot(sp3)

# trunc'd profiles
plot(trunc(sp3, 0, 25))
}
