% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalMissingData.R
\name{evalMissingData}
\alias{evalMissingData}
\title{Evaluate Missing Data}
\usage{
evalMissingData(
  x,
  vars,
  name = hzdesgnname(x),
  p = "Cr|R|Cd",
  method = "relative"
)
}
\arguments{
\item{x}{a \code{SoilProfileCollection} object}

\item{vars}{a character vector naming horizon-level attributes in \code{x}}

\item{name}{the name of a horizon-level attribute where horizon designations
are stored}

\item{p}{REGEX pattern used to match non-soil horizons}

\item{method}{'relative' (proportion of total) or 'absolute' depths}
}
\value{
A vector values ranging from 0 to 1 (\code{method='relative'}) or 0
to maximum depth in specified depth units (\code{method='absolute'}),
representing the quantity of non-NA data (as specified in \code{vars}) for
each profile.
}
\description{
Evaluate missing data in a SoilProfileCollection object
}
\details{
Data completeness is evaluated by profile, based on the thickness of
horizons with complete horizon-level attribute values (specified in
\code{vars}) divided by the total thickness. The default REGEX pattern,
\code{p}, should catch most non-soil horizons which are excluded from the
evaluation.
}
\examples{

# example data
data(sp2)

# init SPC object
depths(sp2) <- id ~ top + bottom

# compute data completeness
sp2$data.complete <- evalMissingData(sp2, vars = c('r', 'g', 'b'), name = 'name')
sp2$data.complete.abs <- evalMissingData(sp2, vars = c('r', 'g', 'b'),
                                         name = 'name', method = 'absolute')

# rank
new.order <- order(sp2$data.complete)

# plot along data completeness ranking
plot(sp2, plot.order=new.order, name='name')

# add relative completeness axis
# note re-ordering of axis labels
axis(side=1, at=1:length(sp2), labels = round(sp2$data.complete[new.order], 2),
     line=-1.5, cex.axis=0.75)

# add absolute completeness (cm)
axis(side=1, at=1:length(sp2), labels = sp2$data.complete.abs[new.order],
     line=1, cex.axis=0.75)


}
\author{
D.E. Beaudette
}
\keyword{manip}
