% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cba.R
\name{cba_manual}
\alias{cba_manual}
\title{CBA Classifier from provided rules}
\usage{
cba_manual(
  train_raw,
  rules,
  txns,
  rhs,
  classAtt,
  cutp,
  pruning_options = list(input_list_sorted_by_length = FALSE)
)
}
\arguments{
\item{train_raw}{a data frame with raw data (numeric attributes are not discretized).}

\item{rules}{Rules class instance  output by the apriori package}

\item{txns}{Transactions class instance  passed to  the arules method invocation. Transactions are created over discretized data frame  - numeric values are replaced  with intervals such as "(13;45]".}

\item{rhs}{character vectors giving the labels of the items which can appear in the RHS
($rhs element of the APappearance class instance passed to the arules call)}

\item{classAtt}{the name of the class attribute.}

\item{cutp}{list of cutpoints used to discretize data (required for application of the model on continuous data)}

\item{pruning_options}{custom options for the pruning algorithm overriding the default values.}
}
\value{
Object of class \link{CBARuleModel}.
}
\description{
Learns a CBA rule set from supplied rules
}
\examples{
  data(humtemp)
  data_raw<-humtemp
  data_discr <- humtemp

  #custom discretization
  data_discr[,1]<-cut(humtemp[,1],breaks=seq(from=15,to=45,by=5))
  data_discr[,2]<-cut(humtemp[,2],breaks=c(0,40,60,80,100))

  #change interval syntax from (15,20] to (15;20], which is required by MARC
  data_discr[,1]<-as.factor(unlist(lapply(data_discr[,1], function(x) {gsub(",", ";", x)})))
  data_discr[,2]<-as.factor(unlist(lapply(data_discr[,2], function(x) {gsub(",", ";", x)})))
  data_discr[,3] <- as.factor(humtemp[,3])

  #mine rules
  classAtt="Class"
  appearance <- getAppearance(data_discr, classAtt)
  txns_discr <- as(data_discr, "transactions")
  rules <- apriori(txns_discr, parameter =
   list(confidence = 0.5, support= 3/nrow(data_discr), minlen=1, maxlen=5), appearance=appearance)
  inspect(rules)


  rmCBA <- cba_manual(data_raw,  rules, txns_discr, appearance$rhs,
  classAtt, cutp= list(), pruning_options=NULL)
  inspect (rmCBA@rules)
  prediction <- predict(rmCBA,data_discr,discretize=FALSE)
  acc <- CBARuleModelAccuracy(prediction, data_discr[[classAtt]])
  print(paste("Accuracy:",acc))
}
