% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/truncate.R
\name{truncate_layer}
\alias{truncate_layer}
\title{Truncate a Feature Layer}
\usage{
truncate_layer(x, async = FALSE, attachment_only = FALSE, token = arc_token())
}
\arguments{
\item{x}{an object of class \code{FeatureLayer}, \code{Table}, or \code{ImageServer}.}

\item{async}{default \code{FALSE}. It is recommended to set \code{TRUE} for
larger datasets.}

\item{attachment_only}{default \code{FALSE}. Deletes all the attachments for this
layer. None of the layer features will be deleted when \code{TRUE}.}

\item{token}{your authorization token.}
}
\value{
a named list with the name "success" and a value of \code{TRUE} or \code{FALSE}
}
\description{
Removes all features in a Feature Layer or Table and resets the object ID
counter. Truncating a Feature Layer does not change the schema of the data
(does not add, remove, or alter existing database columns, constraints,
or indexes).
}
\examples{
\dontrun{

  # authorize using code flow
  set_arc_token(auth_code())

  # create a FeatureLayer object
  flayer <- arc_open("your-feature-layer-url")

  # truncate it
  truncate_layer(flayer)
}
}
\references{
\href{https://developers.arcgis.com/rest/services-reference/online/truncate-feature-layer-.htm}{ArcGIS Developers Rest API Doc}
}
