% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/splitTags.R
\name{splitTagsLocal}
\alias{splitTagsGithub}
\alias{splitTagsLocal}
\title{Split tag column in database into two separate columns: tagKey and tagValue}
\usage{
splitTagsLocal(repoDir = NULL)

splitTagsGithub(repo = NULL, user = NULL, branch = "master",
  repoDirGit = FALSE)
}
\arguments{
\item{repoDir}{While working with the local repository. A character denoting
an existing directory of the Repository. If it is set to \code{NULL} (by default),
it will use the \code{repoDir} specified in \link{setLocalRepo}.}

\item{repo}{While working with the Github repository. A character containing
a name of the Github repository on which the Repository is stored.
By default set to \code{NULL} - see \code{Note}.}

\item{user}{While working with the Github repository. A character containing
a name of the Github user on whose account the \code{repo} is created.
By default set to \code{NULL} - see \code{Note}.}

\item{branch}{While working with the Github repository. A character containing
a name of the Github Repository's branch on which the Repository is stored.
Default \code{branch} is \code{master}.}

\item{repoDirGit}{While working with the Github repository. A character containing
a name of a directory on the Github repository on which the Repository is stored.
If the Repository is stored in the main folder of the Github repository,
this should be set to \code{repoDirGit = FALSE} as default.}
}
\value{
A \code{data.frame} with 4 columns: \code{artifact}, \code{tagKey},
\code{tagValue} and \code{createdDate}.
}
\description{
\code{splitTagsLocal} and \code{splitTagsGithub} functions split \code{tag} column from
\emph{tag} table placed in \code{backpack.db} into two separate columns:
\code{tagKey} and \code{tagValue}.
}
\details{
\code{tag} column from \emph{tag} table has normally the follwing structure:
\code{TagKey:TagValue}. \code{splitTagsLocal} and \code{splitTagsGithub} functions
can be used to split \code{tag} column into two separate columns:
\code{tagKey} and \code{tagValue}. As a result functions from \code{dplyr} package
can be used to easily summarize, search, and extract artifacts' Tags.
See \code{examples}.
}
\note{
If \code{repo} and \code{user} are set to \code{NULL} (as default) in the Github mode
then global parameters set in \link{setGithubRepo} function are used.

Sometimes we can use \code{addTags*} function or \code{userTags} parameter
in \code{saveToRepo} to specify a \code{Tag} which might not match
\code{TagKey:TagValue} structure. It is simply \code{Tag}. In this case
\code{tagKey = userTags} and \code{tagValue = Tag}. See \code{examples}.

To learn more about \code{Tags} and \code{Repository} structure check
\link{Tags} and \link{Repository}.
}
\examples{
\dontrun{
## LOCAL VERSION

# Creating example default repository
exampleRepoDir <- tempfile()
createEmptyRepo( exampleRepoDir, default = TRUE )

# Adding new artifacts to repository
data(iris)
saveToRepo(iris, repoDir = exampleRepoDir )
library(datasets)
data(iris3)
saveToRepo(iris3)
data(longley)
saveToRepo(longley)

# Let's see the difference in tag table in backpack.db
showLocalRepo( method = "tags" ) # a data frame with 3 columns
splitTagsLocal()                 # a data frame with 4 columns

# Now we can sum up what kind of Tags we have in our repository.
library(dplyr)
splitTagsLocal() \%>\%
  group_by(tagKey) \%>\%
  summarise(count = n())

# Deleting existing repository
deleteRepo(exampleRepoDir, deleteRoot = TRUE)
rm(exampleRepoDir)

## Example with Tag that does not match TagKey:TagValue structure

# Creating example default repository
exampleRepoDir <- tempfile()
createEmptyRepo( exampleRepoDir, default = TRUE )
data(iris)
# adding special Tag "lengthOne" to iris artifact and saving to repository
saveToRepo(iris, repoDir = exampleRepoDir,
           userTags = "lengthOne")

# Let's see the difference in tag table in backpack.db
showLocalRepo(method = "tags")
splitTagsLocal()
# We can see that splitTagsLocal added tagKey = userTags to "lengthOne" Tag.

# Deleting existing repository
deleteRepo(exampleRepoDir, deleteRoot = TRUE)
rm(exampleRepoDir)

## Github Version
# Let's check how does table tag look like while we are using the
# Gitub repository.
# We will choose only special columns of data frames that show Tags
showGithubRepo( user = "pbiecek", repo = "archivist", method = "tags" )[,2]
splitTagsGithub( user = "pbiecek", repo = "archivist" )[,2:3]

}
}
\author{
Witold Chodor , \email{witoldchodor@gmail.com}
}
\seealso{
Other archivist: \code{\link{Repository}};
  \code{\link{Tags}}; \code{\link{\%a\%}};
  \code{\link{addTagsRepo}}; \code{\link{agithub}},
  \code{\link{archivist-github-integration}};
  \code{\link{ahistory}}; \code{\link{aoptions}};
  \code{\link{archive}}; \code{\link{archivist-package}};
  \code{\link{aread}}; \code{\link{asearch}};
  \code{\link{cache}}; \code{\link{cloneGithubRepo}};
  \code{\link{copyGithubRepo}},
  \code{\link{copyLocalRepo}};
  \code{\link{createEmptyGithubRepo}},
  \code{\link{createEmptyLocalRepo}},
  \code{\link{createEmptyRepo}}; \code{\link{deleteRepo}};
  \code{\link{getTagsGithub}}, \code{\link{getTagsLocal}};
  \code{\link{loadFromGithubRepo}},
  \code{\link{loadFromLocalRepo}}; \code{\link{md5hash}};
  \code{\link{multiSearchInGithubRepo}},
  \code{\link{multiSearchInLocalRepo}},
  \code{\link{searchInGithubRepo}},
  \code{\link{searchInLocalRepo}};
  \code{\link{rmFromRepo}}; \code{\link{saveToRepo}};
  \code{\link{setGithubRepo}}, \code{\link{setLocalRepo}};
  \code{\link{shinySearchInLocalRepo}};
  \code{\link{showGithubRepo}},
  \code{\link{showLocalRepo}};
  \code{\link{summaryGithubRepo}},
  \code{\link{summaryLocalRepo}};
  \code{\link{zipGithubRepo}}, \code{\link{zipLocalRepo}}
}

