% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchInRepo.R
\name{searchInLocalRepo}
\alias{multiSearchInLocalRepo}
\alias{multiSearchInRemoteRepo}
\alias{searchInLocalRepo}
\alias{searchInRemoteRepo}
\title{Search for an Artifact in the Repository Using Tags}
\usage{
searchInLocalRepo(pattern, repoDir = aoptions("repoDir"), fixed = TRUE,
  intersect = TRUE)

searchInRemoteRepo(pattern, repo = aoptions("repo"),
  user = aoptions("user"), branch = "master", subdir = aoptions("subdir"),
  repoType = aoptions("repoType"), fixed = TRUE, intersect = TRUE)

multiSearchInLocalRepo(...)

multiSearchInRemoteRepo(...)
}
\arguments{
\item{pattern}{If \code{fixed = TRUE}: a character denoting a \code{Tag} which is to be searched for in the Repository.
It is also possible to specify \code{pattern} as a list of 
length 2 with \code{dateFrom} and \code{dateTo}; see details. If \code{fixed = FALSE}: a regular expression 
specifying the beginning of a \code{Tag}, which will be used to search for artifacts. If of length more than one and if 
\code{intersect = TRUE} then artifacts that match all conditions are returned. If \code{intersect = FALSE} then artifacts that match any condition
are returned. See examples.}

\item{repoDir}{A character denoting an existing directory in which artifacts will be searched for.}

\item{fixed}{A logical value specifying how \code{artifacts} should be searched for.
If \code{fixed = TRUE} (default) then artifacts are searched for by using \code{pattern = "Tag"} argument.
If \code{fixed = FALSE} then artifacts are searched for by using \code{pattern = "regular expression"} argument.
The latter is wider and more flexible method, e.g.,
using \code{pattern = "name", fixed = FALSE} arguments enables to search for all artifacts in the \code{Repository}.}

\item{intersect}{A logical value. Used only when \code{length(pattern) > 1 & is.character(pattern)}.
See \code{pattern} for more details.}

\item{repo}{While working with the Remote repository. A character containing a name of the Remote repository on which the Repository is stored.
By default set to \code{NULL} - see \code{Note}.}

\item{user}{While working with the Remote repository. A character containing a name of the Remote user on whose account the \code{repo} is created.
By default set to \code{NULL} - see \code{Note}.}

\item{branch}{While working with the Remote repository. A character containing a name of 
the Remote Repository's branch on which the Repository is stored. Default \code{branch} is \code{master}.}

\item{subdir}{While working with the Remote repository. A character containing a name of a directory on the Remote repository 
on which the Repository is stored. If the Repository is stored in the main folder of the Remote repository, this should be set 
to \code{subdir = "/"} as default.}

\item{repoType}{A character containing a type of the remote repository. Currently it can be 'github' or 'bitbucket'.}

\item{...}{Used for old deprecated functions.}
}
\value{
\code{searchInRepo} returns character vector of \code{md5hashes} of artifacts that were searched for.
Those are hashes assigned to artifacts while they were saved in the Repository
by the \link{saveToLocalRepo} function. If the artifact
is not in the Repository then a logical value \code{FALSE} is returned.
}
\description{
\code{searchInRepo} searches for an artifact in the \link{Repository} using it's \link{Tags}.
To learn more about artifacts visit \link[archivist]{archivist-package}.
}
\details{
\code{searchInRepo} searches for an artifact in the Repository using it's \code{Tag} 
(e.g., \code{name}, \code{class} or \code{archiving date}). \code{Tags} are used in a \code{pattern}
parameter. For various artifact classes different \code{Tags} can be searched for. 
See \link{Tags}. If a \code{pattern} is a list of length 2 then \code{md5hashes} of all 
artifacts created from date \code{dateFrom} to date \code{dateTo} are returned. The date 
should be formatted according to the YYYY-MM-DD format, e.g., \code{"2014-07-31"}.

\code{Tags}, used in a \code{pattern} parameter, should be determined according to the 
format: \code{"TagKey:TagValue"} - see examples.
}
\note{
If \code{repo}, \code{user}, \code{subdir} and \code{repoType} are not specified in the Remote mode then global parameters
set in \link{setRemoteRepo} function are used.

Bug reports and feature requests can be sent to \href{https://github.com/pbiecek/archivist/issues}{https://github.com/pbiecek/archivist/issues}
}
\examples{
\dontrun{
# objects preparation

  showLocalRepo(method = "md5hashes", 
     repoDir = system.file("graphGallery", package = "archivist"))
  showLocalRepo(method = "tags", 
     repoDir = system.file("graphGallery", package = "archivist"))
  
  # Tag search, fixed version
  searchInLocalRepo( "class:ggplot", repoDir = exampleRepoDir )
  searchInLocalRepo( "name:", repoDir = exampleRepoDir )
  # Tag search, regex version
  searchInLocalRepo( "class", repoDir = exampleRepoDir, fixed = FALSE )
  
  # Github version
  # check the state of the Repository
  summaryRemoteRepo( user="pbiecek", repo="archivist" )
  showRemoteRepo( user="pbiecek", repo="archivist" )
  showRemoteRepo( user="pbiecek", repo="archivist", method = "tags" )
  # Tag search, fixed version
  searchInRemoteRepo( "varname:Sepal.Width", user="pbiecek", repo="archivist" )
  searchInRemoteRepo( "class:lm", user="pbiecek", repo="archivist", branch="master" )
  searchInRemoteRepo( "name:myplot123", user="pbiecek", repo="archivist" )
  
  # Tag search, regex version
  searchInRemoteRepo( "class", user="pbiecek", repo="archivist",  fixed = FALSE )
  searchInRemoteRepo( "name", user="pbiecek", repo="archivist", fixed = FALSE )
  
  # also on Github
  
  # Remeber to set dateTo parameter to actual date because sometimes we update datasets.
  searchInRemoteRepo( pattern = list( dateFrom = "2015-10-01", dateTo = "2015-11-30" ), 
                      user="pbiecek", repo="archivist", branch="master" )
  
  
  # many archivist-like Repositories on one Remote repository
  
  searchInRemoteRepo( pattern = "name", user="MarcinKosinski", repo="Museum", 
  branch="master", subdir="ex1", fixed = FALSE )

  searchInRemoteRepo( pattern = "name", user="MarcinKosinski", repo="Museum", 
                   branch="master", subdir="ex2", fixed = FALSE )
 
 # multi versions
 searchInRemoteRepo( pattern=c("varname:Sepal.Width", "class:lm", "name:myplot123"), 
                         user="pbiecek", repo="archivist", intersect = FALSE )
  
}
}
\author{
Marcin Kosinski, \email{m.p.kosinski@gmail.com}
}
\seealso{
Other archivist: \code{\link{Repository}},
  \code{\link{Tags}}, \code{\link{\%a\%}},
  \code{\link{addHooksToPrint}}, \code{\link{addTagsRepo}},
  \code{\link{aformat}}, \code{\link{ahistory}},
  \code{\link{alink}}, \code{\link{aoptions}},
  \code{\link{archivist-package}}, \code{\link{aread}},
  \code{\link{asearch}}, \code{\link{asession}},
  \code{\link{atrace}}, \code{\link{cache}},
  \code{\link{copyLocalRepo}},
  \code{\link{createLocalRepo}},
  \code{\link{createMDGallery}},
  \code{\link{deleteLocalRepo}},
  \code{\link{getRemoteHook}}, \code{\link{getTagsLocal}},
  \code{\link{loadFromLocalRepo}}, \code{\link{md5hash}},
  \code{\link{restoreLibs}}, \code{\link{rmFromLocalRepo}},
  \code{\link{saveToLocalRepo}},
  \code{\link{setLocalRepo}},
  \code{\link{shinySearchInLocalRepo}},
  \code{\link{showLocalRepo}},
  \code{\link{splitTagsLocal}},
  \code{\link{summaryLocalRepo}},
  \code{\link{zipLocalRepo}}

Other archivist: \code{\link{Repository}},
  \code{\link{Tags}}, \code{\link{\%a\%}},
  \code{\link{addHooksToPrint}}, \code{\link{addTagsRepo}},
  \code{\link{aformat}}, \code{\link{ahistory}},
  \code{\link{alink}}, \code{\link{aoptions}},
  \code{\link{archivist-package}}, \code{\link{aread}},
  \code{\link{asearch}}, \code{\link{asession}},
  \code{\link{atrace}}, \code{\link{cache}},
  \code{\link{copyLocalRepo}},
  \code{\link{createLocalRepo}},
  \code{\link{createMDGallery}},
  \code{\link{deleteLocalRepo}},
  \code{\link{getRemoteHook}}, \code{\link{getTagsLocal}},
  \code{\link{loadFromLocalRepo}}, \code{\link{md5hash}},
  \code{\link{restoreLibs}}, \code{\link{rmFromLocalRepo}},
  \code{\link{saveToLocalRepo}},
  \code{\link{setLocalRepo}},
  \code{\link{shinySearchInLocalRepo}},
  \code{\link{showLocalRepo}},
  \code{\link{splitTagsLocal}},
  \code{\link{summaryLocalRepo}},
  \code{\link{zipLocalRepo}}

Other archivist: \code{\link{Repository}},
  \code{\link{Tags}}, \code{\link{\%a\%}},
  \code{\link{addHooksToPrint}}, \code{\link{addTagsRepo}},
  \code{\link{aformat}}, \code{\link{ahistory}},
  \code{\link{alink}}, \code{\link{aoptions}},
  \code{\link{archivist-package}}, \code{\link{aread}},
  \code{\link{asearch}}, \code{\link{asession}},
  \code{\link{atrace}}, \code{\link{cache}},
  \code{\link{copyLocalRepo}},
  \code{\link{createLocalRepo}},
  \code{\link{createMDGallery}},
  \code{\link{deleteLocalRepo}},
  \code{\link{getRemoteHook}}, \code{\link{getTagsLocal}},
  \code{\link{loadFromLocalRepo}}, \code{\link{md5hash}},
  \code{\link{restoreLibs}}, \code{\link{rmFromLocalRepo}},
  \code{\link{saveToLocalRepo}},
  \code{\link{setLocalRepo}},
  \code{\link{shinySearchInLocalRepo}},
  \code{\link{showLocalRepo}},
  \code{\link{splitTagsLocal}},
  \code{\link{summaryLocalRepo}},
  \code{\link{zipLocalRepo}}
}

