% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve_layers_by_geometry.R
\name{get_layers_by_spatial}
\alias{get_layers_by_spatial}
\alias{get_layer_by_poly}
\alias{get_layer_by_line}
\alias{get_layer_by_point}
\alias{get_layer_by_multipoint}
\alias{get_layer_by_envelope}
\alias{get_layer_by_spatial}
\title{Retrieve ArcGIS REST API spatial layer by spatial query}
\usage{
get_layer_by_poly(url, geometry, sp_rel = "esriSpatialRelContains", ...)

get_layer_by_line(url, geometry, sp_rel = "esriSpatialRelIntersects", ...)

get_layer_by_point(url, geometry, sp_rel = "esriSpatialRelIntersects", ...)

get_layer_by_multipoint(
  url,
  geometry,
  sp_rel = "esriSpatialRelIntersects",
  ...
)

get_layer_by_envelope(url, geometry, sp_rel = "esriSpatialRelIntersects", ...)

get_layer_by_spatial(
  url,
  geometry,
  geom_type,
  sp_ref = NULL,
  sp_rel = "esriSpatialRelIntersects",
  ...
)
}
\arguments{
\item{url}{A character string of the url for the layer to pull}

\item{geometry}{An \code{sf} object used for the spatial query}

\item{sp_rel}{Character. The type of relationship to query by.}

\item{...}{Additional arguements to pass to \code{\link{get_spatial_layer}}}

\item{geom_type}{A character of the geometry type to be used. This param is
automatically specified in all \code{get_layer_by_*} functions except
\code{get_spatial_layer}}

\item{sp_ref}{The spatial reference value}
}
\value{
An object of class "sf" of the appropriate layer
}
\description{
These functions are wrappers around \code{\link{get_spatial_layer}} that are
specialized for querying by a spatial layer. They will make a POST request
to the query URL which returns data (if available) based on the appropriate
spatial feature (\code{geometry}) and relationship (\code{sp_rel}).
}
\examples{
base_wdnr_url <- "https://dnrmaps.wi.gov/arcgis/rest/services/"
hydro_path <- "WT_SWDV/WT_Inland_Water_Resources_WTM_Ext_v2/MapServer/2"
hydro_url <- paste0(base_wdnr_url, hydro_path)
mke_waters <- get_layer_by_poly(url = hydro_url, mke_county)
}
