% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilityfcns.R
\name{residuals.arfima}
\alias{residuals.arfima}
\alias{resid.arfima}
\title{Extract the Residuals of a Fitted Object}
\usage{
\method{residuals}{arfima}(object, reg = FALSE, ...)
}
\arguments{
\item{object}{A fitted \code{arfima} object}

\item{reg}{Whether to extract the regression residuals instead.  If
\code{TRUE}, throws an error if no regression was done.}

\item{\dots}{Optional parameters.  Currently not used.}
}
\value{
A list of vectors of residuals, one for each mode.
}
\description{
Extracts the residuals or regression residuals from a fitted \code{arfima}
object
}
\examples{

\donttest{
set.seed(8564)
sim <- arfima.sim(1000, model = list(phi = c(0.2, 0.1), dfrac = 0.4, theta = 0.9))
fit <- arfima(sim, order = c(2, 0, 1), back=T)

fit

resid <- resid(fit)
par(mfrow = c(1, 3))
plot(resid[[1]])
plot(resid[[2]])
plot(resid[[3]])
fitted <- fitted(fit)
plot(fitted[[1]], resid[[1]])
plot(fitted[[2]], resid[[2]])
plot(fitted[[3]], resid[[3]])
par(mfrow = c(1, 1))
}

}
\references{
Veenstra, J.Q. Persistence and Antipersistence:  Theory and
Software (PhD Thesis)
}
\seealso{
\code{\link{arfima}}, \code{\link{fitted.arfima}}
}
\author{
JQ (Justin) Veenstra
}
\keyword{ts}
