% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sims.R
\name{arfima.sim}
\alias{arfima.sim}
\title{Simulate an ARFIMA time series.}
\usage{
arfima.sim(n, model = list(phi = numeric(0), theta = numeric(0), dint = 0,
  dfrac = numeric(0), H = numeric(0), alpha = numeric(0), seasonal = list(phi =
  numeric(0), theta = numeric(0), dint = 0, period = numeric(0), dfrac =
  numeric(0), H = numeric(0), alpha = numeric(0))), useC = 3, sigma2 = 1,
  rand.gen = rnorm, muHat = 0, zinit = NULL, innov = NULL, ...)
}
\arguments{
\item{n}{The number of points to be generated.}

\item{model}{The model to be simulated from.  The phi and theta arguments
should be vectors with the values of the AR and MA parameters. Note that
Box-Jenkins notation is used for the MA parameters: see the "Details"
section of \code{\link{arfima}}.  The dint argument indicates how much
differencing should be required to make the process stationary.  The dfrac,
H, and alpha arguments are FDWN, FGN and PLA values respectively; note that
only one (or none) of these can have a value, or an error is returned. The
seasonal argument is a list, with the same parameters, and a period, as the
model argument. Note that with a seasonal model, we can have mixing of
FDWN/FGN/HD noise: one in the non-seasonal part, and the other in the
seasonal part.}

\item{useC}{How much interfaced C code to use: an integer between 0 and 3.
The value 3 is strongly recommended. See the "Details" section of
\code{\link{arfima}}.}

\item{sigma2}{The desired variance for the innovations of the series.}

\item{rand.gen}{The distribution of the innovations.  Any distribution
recognized by \code{R} is possible}

\item{muHat}{The theoretical mean of the series before integration (if
integer integration is done)}

\item{zinit}{Used for prediction; not meant to be used directly.  This
allows a start of a time series to be specified before inverse differencing
(integration) is applied.}

\item{innov}{Used for prediction; not meant to be used directly.  This
allows for the use of given innovations instead of ones provided by
\code{rand.gen}.}

\item{\dots}{Other parameters passed to the random variate generator;
currently not used.}
}
\value{
A sample from a multivariate normal distribution that has a
covariance structure defined by the autocovariances generated for given
parameters.  The sample acts like a time series with the given parameters.
}
\description{
This function simulates an long memory ARIMA time series, with one of
fractionally differenced white noise (FDWN), fractional Gaussian noise
(FGN), power-law autocovariance (PLA) noise, or short memory noise and
possibly seasonal effects.
}
\details{
A suitably defined stationary series is generated, and if either of the
dints (non-seasonal or seasonal) are greater than zero, the series is
integrated (inverse-differenced) with zinit equalling a suitable amount of
0s if not supplied.  Then a suitable amount of points are taken out of the
beginning of the series (i.e. dint + period * seasonal dint = the length of
zinit) to obtain a series of length n.  The stationary series is generated
by calculating the theoretical autovariance function and using it, along
with the innovations to generate a series as in McLeod et. al. (2007).

\emph{Note:} if you would like to fit a function from a fitted arfima model,
the shortcut \code{arfima(n, fit)} can be used.
}
\examples{

set.seed(6533)
sim <- arfima.sim(1000, model = list(phi = .2, dfrac = .3, dint = 2))

fit <- arfima(sim, order = c(1, 2, 0))
fit

}
\references{
McLeod, A. I., Yu, H. and Krougly, Z. L. (2007) Algorithms for
Linear Time Series Analysis: With R Package Journal of Statistical Software,
Vol. 23, Issue 5

Veenstra, J.Q. Persistence and Antipersistence:  Theory and
Software (PhD Thesis)

P. Borwein (1995) An efficient algorithm for Riemann Zeta function Canadian
Math. Soc. Conf. Proc., 27, pp. 29-34.
}
\seealso{
\code{\link{arfima}}
}
\author{
JQ (Justin) Veenstra
}
\keyword{fit}
\keyword{ts}
