% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ARMApolyroots.R
\name{ARMApolyroots}
\alias{ARMApolyroots}
\title{ARMA polyroots}
\usage{
ARMApolyroots(model, type = c("AR", "MA"))
}
\arguments{
\item{model}{Either of fitted object of class \code{Arima} (i.e., the output of
either \code{\link[stats:arima]{stats::arima()}} or \link{arima}), a list with named elements at
least one of the named elements \code{ar} or \code{ma}, or a vector with named
elements, such as \code{c("ar1" = 0.3, "ar2" = -0.2, "ma1" = 0.14)} Seasonal
coefficients are ignored.}

\item{type}{character of value "AR" or "MA", indicating whether or not the
AR or MA polynomial roots are desired.}
}
\value{
A numeric vector containing the roots of the MA or AR polynomials
}
\description{
This function calculates the roots of the AR or MA polynomials that
correspond to an ARMA model.
}
\examples{
set.seed(123456)
ARMApolyroots(sample_ARMA_coef((order = c(2, 1))), type = "AR")

mod <- arima(lh, order = c(3,0,0))
ARMApolyroots(mod, type = "AR")
}
