% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{AbundanceMatrix-class}
\alias{AbundanceMatrix-class}
\alias{.AbundanceMatrix}
\title{Relative Frequency Matrix}
\description{
An S4 class to represent a relative frequency matrix (i.e. the fraction of
times a given datum occurs in a dataset).
}
\section{Slots}{

\describe{
\item{\code{totals}}{A \code{\link{numeric}} vector.}
}}

\section{Matrix ID}{

 When a matrix is first created, an identifier is generated (UUID v4).
 This ID is preserved when coercing to another class. Thus, the object ID is
 unique within the same class, but two objects of different classes can have
 the same ID. This makes it possible to identify objects representing the
 same initial data and associate them with the results of specific
 computations.
}

\section{Get and set}{

 In the code snippets below, \code{x} is a \code{*Matrix} object.
 \describe{
  \item{\code{get_id(x)}}{Get the ID of \code{x}.}
  \item{\code{get_dates(x)} and \code{set_dates(x) <- value}}{Get or set
  the dates of \code{x}.}
  \item{\code{get_coordinates(x)} and \code{set_coordinates(x) <- value}}{Get
  or set the geographical coordinates of \code{x}.}
 }
}

\section{Access}{

 In the code snippets below, \code{x} is a \code{*Matrix} object.
 \describe{
  \item{\code{dim(x)}}{Returns the dimension of \code{x}.}
  \item{\code{nrow(x)}}{Returns the number of rows present in \code{x}.}
  \item{\code{ncol(x)}}{Returns the number of columns present in \code{x}.}
  \item{\code{dimnames(x)}, \code{dimnames(x) <- value}}{Retrieves or sets
  the row dimnames of \code{x} according to \code{value}.}
  \item{\code{rownames(x)}, \code{rownames(x) <- value}}{Retrieves or sets
  the row names of \code{x} according to \code{value}.}
  \item{\code{colnames(x)}, \code{colnames(x) <- value}}{Retrieves or sets
  the column names of \code{x} according to \code{value}.}
 }
}

\section{Subset}{

 In the code snippets below, \code{x} is a \code{*Matrix} object.
 \describe{
  \item{\code{x[i, j]}}{Extracts elements selected by subscripts \code{i}
  and \code{j}. Indices are \code{\link{numeric}}, \code{\link{integer}} or
  \code{\link{character}} vectors or empty (missing) or \code{NULL}.
  Numeric values are coerced to \code{\link{integer}} as by
  \code{\link{as.integer}} (and hence truncated towards zero).
  Character vectors will be matched to the name of the elements.
  An empty index (a comma separated blank) indicates that all
  entries in that dimension are selected.
  Returns an object of the same class as \code{x}.}
  \item{\code{x[[i]]}}{Extracts a single element selected by subscript
  \code{i}.}
 }
}

\examples{
## Create a count data matrix
A1 <- CountMatrix(data = sample(0:10, 100, TRUE), nrow = 10, ncol = 10)

## Access
get_id(A1)
dim(A1) # Get the matrix dimensions
colnames(A1) <- letters[11:20] # Set the column names
colnames(A1) # Get the column names
rownames(A1) <- LETTERS[1:10] # Set the row names
rownames(A1) # Get the rownames

## Subset
A1[[1]] # Get the first value
A1[, ] # Get all values
A1[1, ] # Get the first row
A1[c("A", "B", "C"), ] # Get the first three rows
A1[c("A", "B", "C"), 1] # Get the first three rows of the first column
A1[, 1, drop = FALSE] # Get the first column

## Coerce counts to relative frequencies
B <- as_abundance(A1)
## Row sums are internally stored before coercing to a frequency matrix
get_totals(B) # Get row sums
## This allows to restore the source data
A2 <- as_count(B)
all(A1 == A2)
## Coerce to a co-occurrence matrix
B <- as_occurrence(A1)
}
\seealso{
\linkS4class{NumericMatrix}

Other matrix: 
\code{\link{CountMatrix-class}},
\code{\link{IncidenceMatrix-class}},
\code{\link{LogicalMatrix-class}},
\code{\link{Matrix-class}},
\code{\link{NumericMatrix-class}},
\code{\link{OccurrenceMatrix-class}},
\code{\link{SimilarityMatrix-class}},
\code{\link{StratigraphicMatrix-class}},
\code{\link{coerce}()}
}
\author{
N. Frerebeau
}
\concept{matrix}
