.onAttach <- function(...) {
  mylib <- dirname(system.file(package = "arm"))
  ver <- packageDescription("arm", lib = mylib)$Version
  builddate <- packageDescription("arm", lib = mylib)$Date
  cat(paste("\narm (Version ", ver, ", built: ", builddate, ")\n", sep = ""))
  #cat ("Working directory is", getwd(), "\n")
  if(!any(search()=="package:MASS"))
    require(MASS) 
  if(!any(search()=="package:Matrix"))
    require(Matrix)
  if(!any(search()=="package:lme4"))
    require(lme4) 
  if(!any(search()=="package:R2WinBUGS"))
    require(R2WinBUGS)
  if(!any(search()=="package:BRugs"))
    require(BRugs) 
  options(digits = 2)
}
