% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/4_NetworkModels.R
\name{OpenJacksonNetwork}
\alias{OpenJacksonNetwork}
\title{Obtains the main characteristics of an Open Jackson network model}
\usage{
OpenJacksonNetwork(lambda = c(20, 30), mu = c(100, 25), s = c(1, 2),
  p = matrix(c(0.2, 0.25, 0.1, 0), nrow = 2, ncol = 2))
}
\arguments{
\item{lambda}{Vector of arrival rates at each node}

\item{mu}{Vector of mean service rates}

\item{s}{Vector with the number of servers at each node}

\item{p}{Routing matrix, where \ifelse{latex}{\eqn{p_{ij}}}{\out{p<sub>ij</sub>}} is the routing probability from node i to node j}
}
\value{
Returns the next information of an Open Jackson network model:
\item{rho}{Traffic intensity: \eqn{\rho}}
\item{l}{Vector with the number of customers in the nodes: \eqn{L}}
\item{lq}{Vector with the number of customers in the queue at each node: \ifelse{latex}{\eqn{L_{q}}}{\out{<i>L<sub>q</sub></i>}}}
\item{w}{Vector with the waiting time in each node: \eqn{W}}
\item{wq}{Vector with the waiting time in the queue at each node: \ifelse{latex}{\eqn{W_{q}}}{\out{<i>W<sub>q</sub></i>}}}
\item{lt}{Number of customers in the network: \ifelse{latex}{\eqn{L_{Total}}}{\out{<i>L<sub>Total</sub></i>}}}
\item{lqt}{Number of customers in all the queues: \ifelse{latex}{\eqn{L_{qTotal}}}{\out{<i>L<sub>qTotal</sub><i>}}}
\item{wt}{Total waiting time in the network: \ifelse{latex}{\eqn{W_{Total}}}{\out{<i>W<sub>Total</sub></i>}}}
\item{wqt}{Total waiting time in all the queues: \ifelse{latex}{\eqn{W_{qTotal}}}{\out{<i>W<sub>qTotal</sub></i>}}}
\item{eff}{System efficiency: \ifelse{latex}{\eqn{Eff = W/(W-W_q)}}{\out{<i>Eff = W/(W-W<sub>q</sub></i>)}}}
}
\description{
Obtains the main characteristics of an Open Jackson network model
}
\examples{
#Two servers receive a number of tasks per minute;
#20 tasks per minute in the case of the first
#server and 30 tasks per minute in the second one.
#The unique processsor in the first server can manage
#100 tasks per minute, while the two processors in the
#second server only can manage 25 task per minute.
#When a task is close to finish in the server 2, it creates
#a new task in the server 1 with a probability of 25\%,
#the task ends in the other case.
#The tasks that ends in the server 1 creates a new one
#in the same server the 20\% of the times and creates
#a new one in the server 2 the 10\% of the times, ending
#in other case.

OpenJacksonNetwork(lambda=c(20, 30),
                   mu=c(100, 25),
                   s=c(1,2),
                   p=matrix(c(0.2,0.1,
                              0.25,0), 2, byrow = TRUE))
}
\seealso{
Other AnaliticalModels: \code{\link{ClosedJacksonNetwork}};
  \code{\link{M_M_1_INF_H}}; \code{\link{M_M_1_K}};
  \code{\link{M_M_1}}; \code{\link{M_M_INF}};
  \code{\link{M_M_S_INF_H_Y}}; \code{\link{M_M_S_INF_H}};
  \code{\link{M_M_S_K}}; \code{\link{M_M_S}}
}

