% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-table.R
\name{read_table}
\alias{read_table}
\alias{read_arrow}
\title{Read an \link[=Table]{arrow::Table} from a stream}
\usage{
read_table(stream)

read_arrow(stream)
}
\arguments{
\item{stream}{stream.
\itemize{
\item a \link[=RecordBatchFileReader]{arrow::RecordBatchFileReader}:
read an \link[=Table]{arrow::Table}
from all the record batches in the reader
\item a \link[=RecordBatchStreamReader]{arrow::RecordBatchStreamReader}:
read an \link[=Table]{arrow::Table} from the remaining record batches
in the reader
\item a string file path: interpret the file as an arrow
binary file format, and uses a \link[=RecordBatchFileReader]{arrow::RecordBatchFileReader}
to process it.
\item a raw vector: read using a \link[=RecordBatchStreamReader]{arrow::RecordBatchStreamReader}
}}
}
\value{
\itemize{
\item \code{read_table} returns an \link[=Table]{arrow::Table}
\item \code{read_arrow} returns a \code{data.frame}
}
}
\description{
Read an \link[=Table]{arrow::Table} from a stream
}
\details{
The methods using \link[=RecordBatchFileReader]{arrow::RecordBatchFileReader} and
\link[=RecordBatchStreamReader]{arrow::RecordBatchStreamReader} offer the most
flexibility. The other methods are for convenience.
}
