% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parquet.R
\docType{class}
\name{ParquetFileReader}
\alias{ParquetFileReader}
\title{ParquetFileReader class}
\description{
This class enables you to interact with Parquet files.
}
\section{Factory}{


The \code{ParquetFileReader$create()} factory method instantiates the object and
takes the following arguments:
\itemize{
\item \code{file} A character file name, raw vector, or Arrow file connection object
(e.g. \code{RandomAccessFile}).
\item \code{props} Optional \link{ParquetReaderProperties}
\item \code{mmap} Logical: whether to memory-map the file (default \code{TRUE})
\item \code{...} Additional arguments, currently ignored
}
}

\section{Methods}{

\itemize{
\item \verb{$ReadTable(col_select)}: get an \code{arrow::Table} from the file, possibly
with columns filtered by a character vector of column names or a
\code{tidyselect} specification.
\item \verb{$GetSchema()}: get the \code{arrow::Schema} of the data in the file
}
}

\examples{
\donttest{
f <- system.file("v0.7.1.parquet", package="arrow")
pq <- ParquetFileReader$create(f)
pq$GetSchema()
if (codec_is_available("snappy")) {
  # This file has compressed data columns
  tab <- pq$ReadTable(starts_with("c"))
  tab$schema
}
}
}
