% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.closed.R
\name{is.closed}
\alias{is.closed}
\alias{is.closed,itemsets-method}
\title{Find Closed Itemsets}
\usage{
is.closed(x)

\S4method{is.closed}{itemsets}(x)
}
\arguments{
\item{x}{a set of itemsets.}
}
\value{
a logical vector with the same length as \code{x} indicating for
each element in \code{x} if it is a closed itemset.
}
\description{
Provides the generic function and the method \code{is.closed()} for finding
closed itemsets.
Closed itemsets are used as a concise representation of
frequent itemsets. The closure of an itemset is its largest proper superset
which has the same support (is contained in exactly the same transactions).
An itemset is closed, if it is its own closure (Pasquier et al. 1999).
}
\details{
Closed frequent itemsets can also be mined directly using
\code{\link[=apriori]{apriori()}} or \code{\link[=eclat]{eclat()}} with target \code{"closed frequent itemsets"}.
}
\references{
Nicolas Pasquier, Yves Bastide, Rafik Taouil, and Lotfi Lakhal
(1999). Discovering frequent closed itemsets for association rules. In
\emph{Proceeding of the 7th International Conference on Database Theory},
Lecture Notes In Computer Science (LNCS 1540), pages 398--416. Springer,
1999.
}
\seealso{
Other postprocessing: 
\code{\link{is.generator}()},
\code{\link{is.maximal}()},
\code{\link{is.redundant}()},
\code{\link{is.significant}()},
\code{\link{is.superset}()}

Other associations functions: 
\code{\link{abbreviate}()},
\code{\link{associations-class}},
\code{\link{c}()},
\code{\link{duplicated}()},
\code{\link{extract}},
\code{\link{inspect}()},
\code{\link{is.generator}()},
\code{\link{is.maximal}()},
\code{\link{is.redundant}()},
\code{\link{is.significant}()},
\code{\link{is.superset}()},
\code{\link{itemsets-class}},
\code{\link{match}()},
\code{\link{rules-class}},
\code{\link{sample}()},
\code{\link{sets}},
\code{\link{size}()},
\code{\link{sort}()},
\code{\link{unique}()}
}
\author{
Michael Hahsler
}
\concept{associations functions}
\concept{postprocessing}
\keyword{models}
