\name{hepatoCellular}
\alias{hepatoCellular}
\docType{data}
\title{hepatoCellular
%%   ~~ data name/kind ... ~~
}
\description{
Overall and recurrence-free survival of patients with hepatocellular carcinoma.
}
\usage{data("hepatoCellular")}
\format{
  A data frame with 227 observations on 48 clinical and biomarker variables
  \describe{
    \item{\code{Number}}{Patient ID number}
    \item{\code{Age}}{a numeric vector}
    \item{\code{Gender}}{a numeric vector}
    \item{\code{HBsAg}}{a numeric vector}
    \item{\code{Cirrhosis}}{a numeric vector}
    \item{\code{ALT}}{a numeric vector}
    \item{\code{AST}}{a numeric vector}
    \item{\code{AFP}}{a numeric vector}
    \item{\code{Tumorsize}}{a numeric vector}
    \item{\code{Tumordifferentiation}}{a numeric vector}
    \item{\code{Vascularinvasion}}{a numeric vector}
    \item{\code{Tumormultiplicity}}{a numeric vector}
    \item{\code{Capsulation}}{a numeric vector}
    \item{\code{TNM}}{a numeric vector}
    \item{\code{BCLC}}{a numeric vector}
    \item{\code{OS}}{Overall survival}
    \item{\code{Death}}{1 denotes death, 0 censored}
    \item{\code{RFS}}{Recurrence-free survival}
    \item{\code{Recurrence}}{1 denotes recurrence, 0 censored}
    \item{\code{CXCL17T}}{a numeric vector}
    \item{\code{CXCL17P}}{a numeric vector}
    \item{\code{CXCL17N}}{a numeric vector}
    \item{\code{CD4T}}{a numeric vector}
    \item{\code{CD4N}}{a numeric vector}
    \item{\code{CD8T}}{a numeric vector}
    \item{\code{CD8N}}{a numeric vector}
    \item{\code{CD20T}}{a numeric vector}
    \item{\code{CD20N}}{a numeric vector}
    \item{\code{CD57T}}{a numeric vector}
    \item{\code{CD57N}}{a numeric vector}
    \item{\code{CD15T}}{a numeric vector}
    \item{\code{CD15N}}{a numeric vector}
    \item{\code{CD68T}}{a numeric vector}
    \item{\code{CD68N}}{a numeric vector}
    \item{\code{CD4NR}}{a numeric vector}
    \item{\code{CD8NR}}{a numeric vector}
    \item{\code{CD20NR}}{a numeric vector}
    \item{\code{CD57NR}}{a numeric vector}
    \item{\code{CD15NR}}{a numeric vector}
    \item{\code{CD68NR}}{a numeric vector}
    \item{\code{CD4TR}}{a numeric vector}
    \item{\code{CD8TR}}{a numeric vector}
    \item{\code{CD20TR}}{a numeric vector}
    \item{\code{CD57TR}}{a numeric vector}
    \item{\code{CD15TR}}{a numeric vector}
    \item{\code{CD68TR}}{a numeric vector}
    \item{\code{Ki67}}{a numeric vector}
    \item{\code{CD34}}{a numeric vector}
  }
}

\references{
Li L, Yan J, Xu J, Liu C-Q, Zhen Z-J, Chen H-W, Ji Y, Wu Z-P, Hu J-Y, Zheng L, Lau WY (2014) 
 Cxcl17 expression predicts poor prognosis and correlates with adverse immune infiltration in hepatocellular carcinoma. Plos One 9 (10) e110064.

Li L, Yan J, Xu J, Liu C-Q, Zhen Z-J, Chen H-W, Ji Y, Wu Z-P, Hu J-Y, Zheng L, Lau WY (2014) 
 Cxcl17 expression predicts poor prognosis and correlates with adverse immune infiltration in hepatocellular carcinoma. Dryad Digital Repository
 datadryad.org. 

}
\examples{
data(hepatoCellular)

}
\keyword{datasets}
