% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_compare.R
\name{assert_identical}
\alias{assert_identical}
\title{Assert that the input object is identical to a specified value}
\usage{
assert_identical(x, y, msg = NULL, call = rlang::caller_env(), arg_name = NULL)
}
\arguments{
\item{x}{An object to check}

\item{y}{The value to compare against}

\item{msg}{A character string containing the error message to display if \code{x} is not identical to the specified value}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if \code{x} is identical to the specified value, otherwise aborts with the error message specified by \code{msg}
}
\description{
Assert that the input object is identical to a specified value
}
\examples{
try({
assert_identical(3, 3) # Passes
assert_identical(c(3, 3, 3), 3) # Throws error
assert_identical(2, 3) # Throws error
})
}
