% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_type.R
\name{assert_int}
\alias{assert_int}
\title{Assert input is an integer}
\usage{
assert_int(x, msg = NULL, call = rlang::caller_env(), arg_name = NULL)
}
\arguments{
\item{x}{An object}

\item{msg}{A character string containing the error message to display if \code{x} is not an integer}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if \code{x} is an integer, otherwise aborts with the error message specified by \code{msg}
}
\description{
Assert input is an integer
}
\note{
In R, integers are whole numbers.
Both integers and doubles (numbers with decimals) are considered numeric.
This function checks that \code{x} specifically belong to the integer class.
}
\examples{
try({
assert_int(1) # Passes
assert_int(1:10) # Passes
assert_int(c(1, 2, 3)) # Passes
assert_int("a") # Throws default error
assert_int(1.5, msg = "Custom error message") # Throws custom error
})


}
\concept{assert_type}
