% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/assert-is-time.R, R/is-time.R
\name{assert_all_are_after}
\alias{assert_all_are_after}
\alias{assert_all_are_before}
\alias{assert_all_are_in_future}
\alias{assert_all_are_in_past}
\alias{assert_any_are_after}
\alias{assert_any_are_before}
\alias{assert_any_are_in_future}
\alias{assert_any_are_in_past}
\alias{is_after}
\alias{is_before}
\alias{is_in_future}
\alias{is_in_past}
\title{Is the input in the past/future?}
\usage{
assert_all_are_after(x, y, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_any_are_after(x, y, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_all_are_before(x, y, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_any_are_before(x, y, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_all_are_in_future(x, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_any_are_in_future(x, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_all_are_in_past(x, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_any_are_in_past(x, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

is_after(x, y, .xname = get_name_in_parent(x),
  .yname = get_name_in_parent(y))

is_before(x, y, .xname = get_name_in_parent(x),
  .yname = get_name_in_parent(y))

is_in_future(x, .xname = get_name_in_parent(x))

is_in_past(x, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{\code{Date} or \code{POSIXt} input to check.}

\item{y}{Another date-time object to compare against.}

\item{na_ignore}{A logical value.  If \code{FALSE}, \code{NA} values
cause an error; otherwise they do not.  Like \code{na.rm} in many
stats package functions, except that the position of the failing
values does not change.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{.xname}{Not intended to be used directly.}

\item{.yname}{Not intended to be used directly.}
}
\value{
The \code{is_*} function return \code{TRUE} if the input is
a time in the future/past.  The \code{assert_*} functions return nothing but
throw an error if the corresponding \code{is_*} function returns
\code{FALSE}.
}
\description{
Checks to see if the input is a time in the past/future, or before/after
some time point.
}
\details{
The current time is determined by \code{Sys.time}, and the
input is coerced to \code{POSIXct} format if necessary.
}
\note{
Note that the print method for \code{POSIXct} objects means that the
cause attribute (in the event of failures) is not shown.  You can still
access it via, e.g., \code{cause(is_in_past(x))}.
}
\examples{
x <- Sys.time() + c(-1, 100)
is_in_past(x)
is_in_future(x)

# more generally, compare against any date-time
is_before(x, as.POSIXct("9999-12-31"))
is_after(x, as.POSIXct("0001-01-01"))
}
\seealso{
\code{\link{Sys.time}}.
}

