% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert-is-equal-to.R, R/is-equal-to.R
\name{assert_all_are_equal_to}
\alias{assert_all_are_equal_to}
\alias{assert_all_are_greater_than}
\alias{assert_all_are_greater_than_or_equal_to}
\alias{assert_all_are_less_than}
\alias{assert_all_are_less_than_or_equal_to}
\alias{assert_all_are_not_equal_to}
\alias{assert_any_are_equal_to}
\alias{assert_any_are_greater_than}
\alias{assert_any_are_greater_than_or_equal_to}
\alias{assert_any_are_less_than}
\alias{assert_any_are_less_than_or_equal_to}
\alias{assert_any_are_not_equal_to}
\alias{is_equal_to}
\alias{is_greater_than}
\alias{is_greater_than_or_equal_to}
\alias{is_less_than}
\alias{is_less_than_or_equal_to}
\alias{is_not_equal_to}
\title{How does the input relate to a value?}
\usage{
assert_all_are_equal_to(x, y, tol = 100 * .Machine$double.eps,
  na_ignore = FALSE, severity = getOption("assertive.severity", "stop"))

assert_any_are_equal_to(x, y, tol = 100 * .Machine$double.eps,
  na_ignore = FALSE, severity = getOption("assertive.severity", "stop"))

assert_all_are_not_equal_to(x, y, tol = 100 * .Machine$double.eps,
  na_ignore = FALSE, severity = getOption("assertive.severity", "stop"))

assert_any_are_not_equal_to(x, y, tol = 100 * .Machine$double.eps,
  na_ignore = FALSE, severity = getOption("assertive.severity", "stop"))

assert_all_are_greater_than(x, y, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_any_are_greater_than(x, y, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_all_are_greater_than_or_equal_to(x, y, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_any_are_greater_than_or_equal_to(x, y, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_all_are_less_than(x, y, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_any_are_less_than(x, y, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_all_are_less_than_or_equal_to(x, y, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_any_are_less_than_or_equal_to(x, y, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

is_equal_to(x, y, tol = 100 * .Machine$double.eps,
  .xname = get_name_in_parent(x), .yname = get_name_in_parent(x))

is_not_equal_to(x, y, tol = 100 * .Machine$double.eps,
  .xname = get_name_in_parent(x), .yname = get_name_in_parent(x))

is_greater_than(x, y, .xname = get_name_in_parent(x),
  .yname = get_name_in_parent(x))

is_greater_than_or_equal_to(x, y, .xname = get_name_in_parent(x),
  .yname = get_name_in_parent(x))

is_less_than(x, y, .xname = get_name_in_parent(x),
  .yname = get_name_in_parent(x))

is_less_than_or_equal_to(x, y, .xname = get_name_in_parent(x),
  .yname = get_name_in_parent(x))
}
\arguments{
\item{x}{A numeric vector.}

\item{y}{Another numeric vector, typically scalar or the same
length as \code{x}.  See note.}

\item{tol}{Values within \code{tol} are considered equal.}

\item{na_ignore}{A logical value.  If \code{FALSE}, \code{NA} values
cause an error; otherwise they do not.  Like \code{na.rm} in many
stats package functions, except that the position of the failing
values does not change.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{.xname}{Not intended to be used directly.}

\item{.yname}{Not intended to be used directly.}
}
\value{
\code{TRUE} if the input \code{x} is equal/not equal/greater 
than/less than \code{y}
}
\description{
Is \code{x} equal/not equal/greater than/less than \code{y}?
}
\note{
The usual recycling rules apply when \code{x} and \code{y}
are different lengths.  See Intro to R for details:
\url{https://cran.r-project.org/doc/manuals/r-devel/R-intro.html#Vector-arithmetic}
\url{https://cran.r-project.org/doc/manuals/r-devel/R-intro.html#The-recycling-rule}
}
\examples{
# Approximate and exact floating point comparisons:
# See FAQ on R 7.31
x <- sqrt(2) * sqrt(2)
is_equal_to(x, 2)
is_equal_to(x, 2, tol = 0)
is_not_equal_to(x, 2)
is_not_equal_to(x, 2, tol = 0)

# Elements of x and y are recycled
is_equal_to(1:6, 1:3)

# Inequalities
x <- c(1 - .Machine$double.neg.eps, 1, 1 + .Machine$double.eps)
is_greater_than(x, 1)
is_greater_than_or_equal_to(x, 1)
is_less_than(x, 1)
is_less_than_or_equal_to(x, 1)
}

