% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/are-same-size.R, R/assert-are-same-size.R
\name{are_same_length}
\alias{are_same_length}
\alias{are_same_length_legacy}
\alias{assert_all_are_same_length_legacy}
\alias{assert_any_are_same_length_legacy}
\alias{assert_are_same_length}
\alias{assert_have_same_dims}
\alias{have_same_dims}
\title{Are the inputs the same length/dimension?}
\usage{
are_same_length(x, y, .xname = get_name_in_parent(x),
  .yname = get_name_in_parent(y))

have_same_dims(x, y, .xname = get_name_in_parent(x),
  .yname = get_name_in_parent(y))

are_same_length_legacy(..., l = list())

assert_are_same_length(x, y, severity = getOption("assertive.severity",
  "stop"))

assert_have_same_dims(x, y, severity = getOption("assertive.severity",
  "stop"))

assert_all_are_same_length_legacy(..., l = list())

assert_any_are_same_length_legacy(..., l = list())
}
\arguments{
\item{x}{An R object or expression.}

\item{y}{Another R object or expression.}

\item{.xname}{Not intended to be used directly.}

\item{.yname}{Not intended to be used directly.}

\item{...}{Some R expressions.}

\item{l}{A list of R expressions.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}
}
\value{
\code{are_same_length} and \code{have_same_dims} return \code{TRUE}
if \code{x} and \code{y} have the same length, or their dimensions are
identical.  The \code{assert_*} functions throw an error on failure.

The legacy function \code{are_same_length_legacy} allows an arbitrary number
of inputs and returns a symmetric square logical matrix which is \code{TRUE}
where pairs of inputs are the same length.  (The new version of the function
is easier to work with, and it is recommended that you switch your code to
it.)
}
\description{
Checks if the inputs are the same length, or have the same dimensions.
}
\examples{
are_same_length(runif(5), list(1, 2:3, 4:6, 7:10, 11:15))
assertive.base::dont_stop(
  assert_are_same_length(runif(6), list(1, 2:3, 4:6, 7:10, 11:15))
)
have_same_dims(
  matrix(1:12, nrow = 4),
  data.frame(x = 1:4, y = 5:8, y = 9:12)
)
have_same_dims(1:5, matrix(1:5))
}
\seealso{
\code{\link[base]{length}}, \code{\link[assertive]{are_identical}}
}

