% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/assert-is-ide.R, R/assert-is-r-mode.R, R/assert-is-r-version.R, R/is-ide.R, R/is-r-mode.R, R/is-r-version.R
\name{assert_is_architect}
\alias{assert_is_architect}
\alias{assert_is_r}
\alias{assert_is_r_alpha}
\alias{assert_is_r_beta}
\alias{assert_is_r_devel}
\alias{assert_is_r_patched}
\alias{assert_is_r_release}
\alias{assert_is_r_release_candidate}
\alias{assert_is_r_stable}
\alias{assert_is_revo_r}
\alias{assert_is_rstudio}
\alias{assert_is_rstudio_desktop}
\alias{assert_is_rstudio_server}
\alias{is_architect}
\alias{is_r}
\alias{is_r_alpha}
\alias{is_r_beta}
\alias{is_r_devel}
\alias{is_r_patched}
\alias{is_r_release}
\alias{is_r_release_candidate}
\alias{is_r_stable}
\alias{is_revo_r}
\alias{is_rstudio}
\title{Are you running R?}
\usage{
assert_is_architect(severity = getOption("assertive.severity", "stop"))

assert_is_revo_r(severity = getOption("assertive.severity", "stop"))

assert_is_rstudio(severity = getOption("assertive.severity", "stop"))

assert_is_rstudio_desktop(severity = getOption("assertive.severity", "stop"))

assert_is_rstudio_server(severity = getOption("assertive.severity", "stop"))

assert_is_r(severity = getOption("assertive.severity", "stop"))

assert_is_r_alpha(severity = getOption("assertive.severity", "stop"))

assert_is_r_beta(severity = getOption("assertive.severity", "stop"))

assert_is_r_devel(severity = getOption("assertive.severity", "stop"))

assert_is_r_patched(severity = getOption("assertive.severity", "stop"))

assert_is_r_release_candidate(severity = getOption("assertive.severity",
  "stop"))

assert_is_r_release(severity = getOption("assertive.severity", "stop"))

assert_is_r_stable(severity = getOption("assertive.severity", "stop"))

is_architect()

is_revo_r()

is_rstudio()

is_r()

is_r_alpha()

is_r_beta()

is_r_devel()

is_r_patched()

is_r_release_candidate()

is_r_release()

is_r_stable()
}
\arguments{
\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}
}
\value{
\code{is_r} wraps \code{is.R}, providing more
information on failure.  \code{is_r_stable}, \code{is_r_patched} and
\code{is_r_devel} tell you what type of R build you are
running.  \code{is_architect}, \code{is_rstudio} and \code{is_revo_r} tell
you if you are running Architect/StatET, RStudio, or Revolution Analytics'
Revolution R build.  \code{is_slave_r} tells you if you are running a slave
instance of R (e.g. when building a package with \code{devtools} or using a
cluster).
The \code{assert_*} functions return nothing but throw an error if
the corresponding \code{is_*} function returns \code{FALSE}.
}
\description{
Checks to see what type of R you are running.
}
\examples{
# If this is FALSE, you really need to ditch that old copy of S-PLUS
is_r()
# Release, patched, devel, etc.
is_r_release()
is_r_patched()
is_r_devel()
is_r_alpha()
is_r_beta()
is_r_release_candidate()
switch(
  version$status,
  Patched                        = assert_is_r_patched(),
  "Under development (unstable)" = assert_is_r_devel(),
  alpha                          = assert_is_r_alpha(),
  beta                           = assert_is_r_beta(),
  RC                             = assert_is_r_release_candidate(),
  assert_is_r_release()
)
# IDE
is_architect()
is_revo_r()
is_rstudio()
assertive.base::dont_stop(assert_is_r())
}
\references{
\url{http://www.revolutionanalytics.com/revolution-r-open}
}
\seealso{
\code{\link[base]{is.R}}, \code{\link[base]{version}}.
}

