% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wdm.R
\name{wdm}
\alias{wdm}
\title{Automated Test Assembly via Weighted (positive) Deviations Method}
\usage{
wdm( ipool,
 id,
 constraints,
 first = NA,
 refine = TRUE,
 permutate = FALSE,
 tieselect = 1,
 verbose = TRUE,
 aprioriadd = NA,
 posthocadd = NA )
}
\arguments{
\item{ipool}{Item by characteristic (property) metadata pool.}

\item{id}{Name of unique item identifier.}

\item{constraints}{Complex list object identifying the constraints to be applied in the ATA (see \code{makeconstobj} for guided process).}

\item{first}{How should item selection start: \code{id} of the item to be selected first from the pool, \code{NA} (default) - select randomly from the pool.}

\item{refine}{Should the final test form be refined against the remaining item pool? Default is \code{TRUE}.}

\item{permutate}{Assemble test forms starting with each item sequentially (as many forms as items in pool) and define final test form based on eligible constraint compliant solutions; Default is \code{FALSE} (currently not available).}

\item{tieselect}{How should tied items be resolved: 1 (default) - select the first item in the list of candidates (sensitive to data sorting); not applicable for situations with all categorical constraints only, 0 - randomly select candidate; not applicable for situations with all categorical constraints only}

\item{verbose}{Should progress of \code{wdm()} be printed to the console? Default = \code{TRUE}.}

\item{aprioriadd}{Force item addition (via IDs) to test before ATA, which affects item selection and constraint attainment success (currently not available).}

\item{posthocadd}{Force item addition (via IDs) to test after ATA, which affects final form specifications (currently not available).}
}
\value{
A complex list object with test assembly specific estimates:
\item{wde}{Estimates of the computational steps deriving the positive weighted deviations and item selection.}
\item{evaluation}{Final assembled test form additive properties across constraints.}
\item{considered}{Estimates of the computational steps when \code{refine = TRUE} evaluating selected items and selecting replacements.}
\item{excluded}{Items from pool excluded.}
\item{excluded_set}{Item sets excluded. Only included if input \code{constobj} includes a \code{set_id}.}
\item{included}{Items from pool included in new test form.}
\item{included_set}{Item sets from pool included in new test form. Only included if input \code{constobj} includes a \code{set_id}.}
\item{initial_ids}{Item sets from pool included in new test form.}
\item{initial_setids}{Item sets from pool included in new test form. Only included if input \code{constobj} includes a \code{set_id}.}
\item{final_ids}{Final item ids in the test form.}
\item{final_setids}{Final set ids in the test form. Only included if input \code{constobj} includes a \code{set_id}.}
}
\description{
Ingests item metadata jointly with target test form constraints and uses the Weighted (positive) Deviations Method (WDM) to construct a test form based on the desired objectives.
}
\examples{
# Specifying constraints
constin <- list(
  nI = 5,                                     # Number of items on the future test
  nC = 4,                                     # Number of constraints to be satisfied
  nameC = c("Content_A","Content_B","p","iSx"), # Name of constraint; must be numeric and must
  # reflect variable name in input
  lowerC = c(2, 3, 3.00, 0.50),               # Lower bound total constraint value on ATA form
  upperC = c(2, 3, 3.50, 0.60),               # Upper bound total constraint value on ATA form
  wC = c(1, 1, 1, 1),                         # Constraint weight used for weighted sum of
                                              # (positive) deviations St
  set_id = NA                                 # Aggregation ID for units / sets 
)

# Running WDM example from Parshall et al. (2002)
testWDM <- wdm( ipool = metadata_example,
                id = "Item",
                constraints = constin,
                first = 2)

# Summary of results
summary(testWDM)

}
\references{
Parhshall, C. G., et al. (2002). Automated test assembly for online administration. In C. G. Parhsall, J. A. Spray, J. C. Kalohn, & T. Davey, Practical considerations in computer based testing (pp.106-125). New York, NY: Springer-Verlag New York, Inc.

Sanders, P. F., & Verschoor, A. J. (1998). Parallel test construction using classical item parameters. Applied Psychological Measurement, 22, 212-223.

Swanson, L., & Stocking, M. L. (1993). A Model and heuristic for solving Very large item selection problems. Applied Psychological Measurement, 17, 151-166.
}
\author{
Gulsah Gurkan (gurkangulsah@gmail.com), Michael Chajewski (mchajewski@hotmail.com)
}
\keyword{"test}
\keyword{assembly"}
\keyword{ata}
\keyword{automated_test_assembly}
\keyword{form"}
\keyword{test_form}
\keyword{testform}
\keyword{wdm}
