% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/two_sample_htest.R
\name{two_sample_htest}
\alias{two_sample_htest}
\alias{two_sample_htest.character}
\alias{two_sample_htest.factor}
\alias{two_sample_htest.logical}
\alias{two_sample_htest.numeric}
\alias{two_sample_htest.ordered}
\title{Two sample hypothesis tests and effect size}
\usage{
two_sample_htest(value, group, ...)

\method{two_sample_htest}{character}(value, group, ...)

\method{two_sample_htest}{factor}(value, group, two_sample_htest.factor = NULL, ...)

\method{two_sample_htest}{logical}(value, group, ...)

\method{two_sample_htest}{numeric}(value, group, two_sample_htest.numeric = NULL, ...)

\method{two_sample_htest}{ordered}(value, group, two_sample_htest.ordered = NULL, ...)
}
\arguments{
\item{value}{An atomic vector. These values will be tested.}

\item{group}{A factor with two levels and same length as \code{value}.
Defines the two groups of \code{value}, that are compared by a two sample hypothesis tests.}

\item{...}{Passed to methods.}

\item{two_sample_htest.factor}{Analog to argument two_sample_htest.numeric}

\item{two_sample_htest.numeric}{Either \code{NULL} or a function. Default is \code{NULL}.
If a function, then it will replace \code{atable:::two_sample_htest.numeric}.
The function must mimic \code{\link{two_sample_htest.numeric}}: arguments are
\code{value}, \code{group} and the ellipsis ... .
Result is a named list with \code{length} > 0 with unique names.}

\item{two_sample_htest.ordered}{Analog to argument two_sample_htest.numeric}
}
\value{
A named list with length > 0, where all elements of the list are atomic and have the same length.

Most hypothesis-test-functions in R like \code{\link[stats]{t.test}} or \code{\link[stats]{chisq.test}}
return an object of class \code{'htest'}. \code{'htest'}-objects are a suitable output for function
\code{two_sample_htest}. Function \code{\link{check_tests}} checks if the output is suitable for
further processing.
}
\description{
Calculates two sample hypothesis tests and effect size depending on the class of its input.
}
\details{
Results are passed to function \code{\link{format_tests}} for the final table.
So the results of \code{two_sample_htest} must have a class for which the generic
\code{\link{format_tests}} has a method.

If you are not pleased with the current hypothesis tests you may alter these functions.
But you must keep the original output-format, see section Value.

Note that the various statistical test functions in R have heterogeneous arguments:
for example \code{\link[stats]{chisq.test}}  and \code{\link[stats]{ks.test}} do not have
formula/data as arguments, whereas \code{\link[stats]{wilcox.test}} and
\code{\link[stats]{kruskal.test}} do. So the function \code{two_sample_htest} is essentially
a wrapper to standardize the arguments of various hypothesis test functions.

As \code{two_sample_htest} is only intended to be applied to unpaired two sample data,
the two arguments \code{value} and \code{group} are sufficient to describe the data.

Note that e.g. for class numeric the p-value is calculated by \code{ks.test} and the effects
size 95\% CI by \code{cohen.d}. As these are two different functions the results may be
contradicting: the p-value of \code{ks.test} can be smaller than 0.05
and the CI of \code{cohen.d} contains 0 at the same time.
}
\section{Methods (by class)}{
\itemize{
\item \code{two_sample_htest(character)}: Casts \code{value} to factor and then calls method \code{two_sample_htest} again.

\item \code{two_sample_htest(factor)}: Calls \code{\link[stats]{chisq.test}} on \code{value}.
Effect size is the odds ratio calculated by \code{\link[stats]{fisher.test}} (if \code{value} has two levels),
or Cramer's V by \code{\link[DescTools]{CramerV}}.

\item \code{two_sample_htest(logical)}: Casts \code{value} to factor and then calls \code{two_sample_htest} again.

\item \code{two_sample_htest(numeric)}: Calls \code{\link[stats]{ks.test}} on \code{value}.
Effect size is Cohen's d calculated by \code{\link[effsize]{cohen.d}}.

\item \code{two_sample_htest(ordered)}: Calls \code{\link[stats]{wilcox.test}} on \code{value}.
Effect size is Cliff's delta calculated by \code{\link[effsize]{cliff.delta}}.

}}
